/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.thread;

import java.io.PrintWriter;
import java.io.StringWriter;
import kd.bos.thread.SetThreadName;
import kd.bos.thread.ThreadLifeCycleListener;

public class ManagedThreadFeature
implements ThreadLifeCycleListener {
    private static final String trace_managed_thread_feature = "bos.traceManagedThreadFeature";
    private static ThreadLocal<Exception[]> thTrackThread = ThreadLocal.withInitial(() -> new Exception[2]);
    private static ThreadLocal<Boolean> th = new ThreadLocal();
    private boolean setThreadName;

    public ManagedThreadFeature() {
        this(true);
    }

    public ManagedThreadFeature(boolean setThreadName) {
        this.setThreadName = setThreadName;
    }

    @Override
    public void start() {
        if (this.setThreadName) {
            SetThreadName.start();
        }
        th.set(true);
        if (ManagedThreadFeature.isTraceManagedThreadFeatureEnabled()) {
            ManagedThreadFeature.thTrackThread.get()[0] = new Exception();
        }
    }

    @Override
    public void end() {
        th.remove();
        if (this.setThreadName) {
            SetThreadName.end();
        }
        if (ManagedThreadFeature.isTraceManagedThreadFeatureEnabled()) {
            ManagedThreadFeature.thTrackThread.get()[1] = new Exception();
        }
    }

    public static boolean isManaged() {
        return Boolean.TRUE.equals(th.get());
    }

    public static boolean isTraceManagedThreadFeatureEnabled() {
        return Boolean.getBoolean(trace_managed_thread_feature);
    }

    public static String getAndRemoveManagedThreadTrace() {
        Exception[] ret = thTrackThread.get();
        thTrackThread.remove();
        if (ret == null || ret[0] == null || ret[1] == null) {
            return "ManagedThreadFeature not set!";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("Set ManagedThreadFeature stack: ");
        ret[0].printStackTrace(pw);
        pw.println("\nClear ManagedThreadFeature stack: ");
        ret[1].printStackTrace(pw);
        return sw.toString();
    }
}

