/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.thread;

import kd.bos.util.ThreadLocals;

public class ShardingStats
implements AutoCloseable {
    private static final ThreadLocal<ShardingStats> thShardingSql = ThreadLocals.create();
    private final ShardingStats parent = thShardingSql.get();
    private String originalSQL;
    private int shardingCount;

    private ShardingStats() {
        thShardingSql.set(this);
    }

    public static ShardingStats create() {
        return new ShardingStats();
    }

    public static ShardingStats get() {
        return thShardingSql.get();
    }

    public void setOriginalSQL(String originalSQL) {
        this.originalSQL = originalSQL;
    }

    public String getOriginalSQL() {
        return this.originalSQL;
    }

    public int getShardingCount() {
        return this.shardingCount;
    }

    public void setShardingCount(int shardingCount) {
        this.shardingCount = shardingCount;
    }

    @Override
    public void close() {
        if (this.parent == null) {
            thShardingSql.remove();
        } else {
            thShardingSql.set(this.parent);
        }
    }

    public String toString() {
        return this.originalSQL + ':' + this.shardingCount;
    }
}

