/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import kd.bos.util.StringUtils;

public class ClassUtils {
    private static final String UNSUPPORTED_CLASS_PACKAGE = "kd.bos.*,java.lang.System.*";
    public static final char ASTERISK_CHAR = '*';

    public static Class<?> forName(String className) throws ClassNotFoundException {
        ClassUtils.checkClassName(className);
        return Class.forName(className);
    }

    private static void checkClassName(String className) {
        for (String ucp : UNSUPPORTED_CLASS_PACKAGE.split(",")) {
            if (!ClassUtils.isMatch(className, ucp)) continue;
            throw new RuntimeException("Unsupported Class.forName class! className=" + className);
        }
    }

    private static boolean isMatch(String s, String p) {
        if (StringUtils.isEmpty(s) || StringUtils.isEmpty(p)) {
            return false;
        }
        int sn = s.length();
        int pn = p.length();
        int i = 0;
        int j = 0;
        int start = -1;
        int match = 0;
        while (i < sn) {
            if (j < pn && (s.charAt(i) == p.charAt(j) || p.charAt(j) == '?')) {
                ++i;
                ++j;
                continue;
            }
            if (j < pn && p.charAt(j) == '*') {
                start = j++;
                match = i;
                continue;
            }
            if (start != -1) {
                j = start + 1;
                i = ++match;
                continue;
            }
            return false;
        }
        while (j < pn) {
            if (p.charAt(j) != '*') {
                return false;
            }
            ++j;
        }
        return true;
    }
}

