/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationUpdateObserver {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationUpdateObserver.class);
    private static LinkedBlockingQueue<String> events = new LinkedBlockingQueue();
    private static ConcurrentHashMap<String, Object> interesters = new ConcurrentHashMap();
    private static ConcurrentHashMap<Class<?>, Method> methods = new ConcurrentHashMap();
    private static boolean STOPFLAG = false;

    public static void notify(String key) {
        events.offer(key);
    }

    public static void stop() {
        STOPFLAG = true;
    }

    public static void registerInterest(String key, Object interest) {
        interesters.put(key, interest);
    }

    private static void notifyInterest(String key) {
        Object obj = interesters.get(key);
        if (obj == null) {
            return;
        }
        Method method = methods.get(obj.getClass());
        if (method == null) {
            try {
                method = obj.getClass().getDeclaredMethod("updateSystemProperty", String.class);
                methods.putIfAbsent(obj.getClass(), method);
            }
            catch (NoSuchMethodException e) {
                log.error(e.getMessage());
            }
            catch (SecurityException e) {
                log.error(e.getMessage());
            }
        }
        if (method != null) {
            try {
                method.invoke(obj, key);
            }
            catch (IllegalAccessException e) {
                log.error(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                log.error(e.getMessage());
            }
            catch (InvocationTargetException e) {
                log.error(e.getMessage());
            }
        }
    }

    static {
        STOPFLAG = false;
        Thread thread = new Thread(new SystemPropertyUpdateScan());
        thread.setDaemon(true);
        thread.start();
    }

    static class SystemPropertyUpdateScan
    implements Runnable {
        SystemPropertyUpdateScan() {
        }

        @Override
        public void run() {
            while (!STOPFLAG) {
                try {
                    String key = (String)events.take();
                    ConfigurationUpdateObserver.notifyInterest(key);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

