/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import com.alibaba.fastjson.util.IOUtils;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;
import org.apache.log4j.Logger;

@SdkPublic
public class HttpUtils {
    private static Logger logger = Logger.getLogger(HttpUtils.class);

    public static String request(String url) {
        return HttpUtils.request(url, "GET");
    }

    public static String request(String url, boolean replaceSpace) {
        return HttpUtils.request(url, "GET", null, replaceSpace);
    }

    public static String request(String url, String requestType) {
        return HttpUtils.request(url, requestType, null);
    }

    public static String request(String url, String requestType, Map<String, String> header) {
        return HttpUtils.request(url, requestType, header, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String request(String url, String requestType, Map<String, String> header, boolean replaceSpace) {
        block12: {
            String string;
            if (StringUtils.isEmpty(url)) {
                throw new IllegalArgumentException("request url can't be null");
            }
            StringBuilder sb = new StringBuilder();
            InputStream raw = null;
            BufferedInputStream reader = null;
            try {
                URL httpUrl = new URL(url);
                HttpURLConnection connection = (HttpURLConnection)httpUrl.openConnection();
                connection.setRequestMethod(requestType.toUpperCase());
                if (header != null) {
                    for (Map.Entry<String, String> item : header.entrySet()) {
                        connection.setRequestProperty(item.getKey(), item.getValue());
                    }
                }
                raw = connection.getInputStream();
                reader = new BufferedInputStream(raw);
                byte[] buffer = new byte[1024];
                String encoding = connection.getContentEncoding();
                if (StringUtils.isEmpty(encoding)) {
                    encoding = "UTF-8";
                } else {
                    boolean support = Charset.isSupported(encoding);
                    if (!support) {
                        encoding = "UTF-8";
                    }
                }
                Charset charset = Charset.forName(encoding);
                int size = 0;
                while ((size = reader.read(buffer, 0, buffer.length)) != -1) {
                    if (size <= 0) continue;
                    sb.append(new String(buffer, 0, size, charset));
                }
                String result = sb.toString();
                string = replaceSpace && result.indexOf("\n") != -1 ? result.replaceAll("\\s*|\t|\r|\n", StringUtils.getEmpty()) : result;
                IOUtils.close((Closeable)reader);
            }
            catch (IOException e) {
                logger.error((Object)e);
                break block12;
            }
            finally {
                IOUtils.close(reader);
                IOUtils.close(raw);
            }
            IOUtils.close((Closeable)raw);
            return string;
        }
        return StringUtils.getEmpty();
    }

    public static String post(String url) {
        return HttpUtils.request(url, "POST");
    }

    public static String post(String url, Map<String, String> header) {
        return HttpUtils.request(url, "POST", header);
    }

    public static String post(String url, Map<String, String> header, String argument) {
        return HttpUtils.post(url, header, argument, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, Map<String, String> header, String argument, boolean replaceSpace) {
        block13: {
            String string;
            if (StringUtils.isEmpty(url)) {
                throw new IllegalArgumentException("post url can't be null");
            }
            StringBuilder sb = new StringBuilder();
            InputStream raw = null;
            BufferedInputStream reader = null;
            OutputStream write = null;
            try {
                URL httpUrl = new URL(url);
                HttpURLConnection connection = (HttpURLConnection)httpUrl.openConnection();
                connection.setRequestMethod("POST");
                if (header != null) {
                    for (Map.Entry<String, String> item : header.entrySet()) {
                        connection.setRequestProperty(item.getKey(), item.getValue());
                    }
                }
                if (StringUtils.isNotEmpty(argument)) {
                    connection.setDoOutput(true);
                    write = connection.getOutputStream();
                    write.write(argument.getBytes());
                }
                raw = connection.getInputStream();
                reader = new BufferedInputStream(raw);
                byte[] buffer = new byte[1024];
                String encoding = connection.getContentEncoding();
                if (StringUtils.isEmpty(encoding)) {
                    encoding = "UTF-8";
                } else {
                    boolean support = Charset.isSupported(encoding);
                    if (!support) {
                        encoding = "UTF-8";
                    }
                }
                Charset charset = Charset.forName(encoding);
                int size = 0;
                while ((size = reader.read(buffer, 0, buffer.length)) != -1) {
                    if (size <= 0) continue;
                    sb.append(new String(buffer, 0, size, charset));
                }
                String result = sb.toString();
                string = replaceSpace && result.indexOf("\n") != -1 ? result.replaceAll("\\s*|\t|\r|\n", StringUtils.getEmpty()) : result;
                IOUtils.close((Closeable)reader);
            }
            catch (IOException e) {
                logger.error((Object)e);
                break block13;
            }
            finally {
                IOUtils.close(reader);
                IOUtils.close(raw);
                IOUtils.close(write);
            }
            IOUtils.close((Closeable)raw);
            IOUtils.close((Closeable)write);
            return string;
        }
        return StringUtils.getEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, Map<String, String> header, InputStream in, boolean replaceSpace) {
        block14: {
            String string;
            if (StringUtils.isEmpty(url)) {
                throw new IllegalArgumentException("post url can't be null");
            }
            StringBuilder sb = new StringBuilder();
            InputStream raw = null;
            BufferedInputStream reader = null;
            OutputStream write = null;
            try {
                byte[] buffer;
                URL httpUrl = new URL(url);
                HttpURLConnection connection = (HttpURLConnection)httpUrl.openConnection();
                connection.setRequestMethod("POST");
                if (header != null) {
                    for (Map.Entry<String, String> item : header.entrySet()) {
                        connection.setRequestProperty(item.getKey(), item.getValue());
                    }
                }
                if (in != null) {
                    connection.setDoOutput(true);
                    write = connection.getOutputStream();
                    buffer = new byte[1024];
                    int size = 0;
                    while ((size = in.read(buffer, 0, buffer.length)) != -1) {
                        if (size <= 0) continue;
                        write.write(buffer, 0, size);
                    }
                }
                raw = connection.getInputStream();
                reader = new BufferedInputStream(raw);
                buffer = new byte[1024];
                String encoding = connection.getContentEncoding();
                if (StringUtils.isEmpty(encoding)) {
                    encoding = "UTF-8";
                } else {
                    boolean support = Charset.isSupported(encoding);
                    if (!support) {
                        encoding = "UTF-8";
                    }
                }
                Charset charset = Charset.forName(encoding);
                int size = 0;
                while ((size = reader.read(buffer, 0, buffer.length)) != -1) {
                    if (size <= 0) continue;
                    sb.append(new String(buffer, 0, size, charset));
                }
                String result = sb.toString();
                string = replaceSpace && result.indexOf("\n") != -1 ? result.replaceAll("\\s*|\t|\r|\n", StringUtils.getEmpty()) : result;
                IOUtils.close((Closeable)reader);
            }
            catch (IOException e) {
                logger.error((Object)e);
                break block14;
            }
            finally {
                IOUtils.close(reader);
                IOUtils.close(raw);
                IOUtils.close(write);
            }
            IOUtils.close((Closeable)raw);
            IOUtils.close((Closeable)write);
            return string;
        }
        return StringUtils.getEmpty();
    }

    public static String getJsonRequest(HttpServletRequest request) throws IOException {
        String charset = request.getCharacterEncoding();
        if (StringUtils.isEmpty(charset)) {
            charset = "UTF-8";
        }
        StringBuilder sb = new StringBuilder();
        try (ServletInputStream raw = request.getInputStream();
             BufferedInputStream reader = new BufferedInputStream((InputStream)raw);){
            byte[] buffer = new byte[1024];
            int size = 0;
            while ((size = reader.read(buffer, 0, buffer.length)) != -1) {
                if (size <= 0) continue;
                sb.append(new String(buffer, 0, size, charset));
            }
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        String result = sb.toString();
        return result;
    }
}

