/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kd.bos.bundle.Resources;
import net.coobird.thumbnailator.Thumbnails;

public class ImageUtils {
    private ImageUtils() {
    }

    public static void scale(InputStream src, OutputStream dist, double scaleRatio) throws IOException {
        Thumbnails.of((InputStream[])new InputStream[]{src}).scale(scaleRatio).toOutputStream(dist);
    }

    public static void rotateAndscale(InputStream src, OutputStream dist, double rotate, double scaleRatio) throws IOException {
        Thumbnails.of((InputStream[])new InputStream[]{src}).rotate(rotate).scale(scaleRatio).toOutputStream(dist);
    }

    public static void scale(BufferedImage src, OutputStream dist, double scaleRatio) throws IOException {
        Thumbnails.of((BufferedImage[])new BufferedImage[]{src}).scale(scaleRatio).toOutputStream(dist);
    }

    public static void scale(BufferedImage src, OutputStream dist, double scaleRatio, String format) throws IOException {
        Thumbnails.of((BufferedImage[])new BufferedImage[]{src}).scale(scaleRatio).outputFormat(format).toOutputStream(dist);
    }

    public static void scale(InputStream src, OutputStream dist, double widthRatio, double heighRatio) throws IOException {
        Thumbnails.of((InputStream[])new InputStream[]{src}).scale(widthRatio, heighRatio).toOutputStream(dist);
    }

    public static void scale(InputStream src, OutputStream dist, int width, int height) throws IOException {
        Thumbnails.of((InputStream[])new InputStream[]{src}).scale((double)width, (double)height).toOutputStream(dist);
    }

    public static void compression(InputStream src, OutputStream dist, double compressionRatio) throws IOException {
        if (compressionRatio < 0.0 || compressionRatio > 1.0) {
            throw new IllegalArgumentException(Resources.getString("bos-util", "ImageUtils_0", new Object[0]));
        }
        Thumbnails.of((InputStream[])new InputStream[]{src}).scale(1.0).outputQuality(compressionRatio).toOutputStream(dist);
    }

    public static void convertFormat(InputStream src, OutputStream dist, String toFormat) throws IOException {
        Thumbnails.of((InputStream[])new InputStream[]{src}).outputFormat(toFormat).toOutputStream(dist);
    }

    public static double getRotateByOrientation(int orientation) {
        double rotate = 0.0;
        switch (orientation) {
            case 3: {
                rotate = 180.0;
                break;
            }
            case 6: {
                rotate = 270.0;
                break;
            }
            case 8: {
                rotate = 90.0;
                break;
            }
        }
        return rotate;
    }

    public static int getImageExifOrientation(InputStream is) throws Exception {
        Metadata readMetadata = ImageMetadataReader.readMetadata((InputStream)is);
        int orientation = 1;
        for (Directory directory : readMetadata.getDirectories()) {
            for (Tag tag : directory.getTags()) {
                if (tag.getTagType() != 274) continue;
                orientation = directory.getInt(tag.getTagType());
            }
        }
        return orientation;
    }
}

