/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.util.StringUtils;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class JSONUtils {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final ObjectMapper mapperIndent = new ObjectMapper();
    private static final ObjectMapper mapperIgnore = new ObjectMapper();

    public static String toString(Object source) throws IOException {
        return JSONUtils.toString(source, false);
    }

    public static String toString(Object source, boolean indent) throws IOException {
        if (indent) {
            mapperIndent.configure(SerializationFeature.INDENT_OUTPUT, true);
            return mapperIndent.writeValueAsString(source);
        }
        String result = mapper.writeValueAsString(source);
        return result;
    }

    public static <T> T cast(String source, Class<T> type) throws IOException {
        return JSONUtils.cast(source, type, false);
    }

    public static <T> T cast(String source, Class<T> type, boolean ignoreUnkownField) throws IOException {
        if (ignoreUnkownField) {
            mapperIgnore.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            return (T)mapperIgnore.readValue(source, type);
        }
        Object result = mapper.readValue(source, type);
        return (T)result;
    }

    public static <T> T cast(String source, Class<?> collectionType, Class<?> ... elementType) throws IOException {
        return JSONUtils.cast(source, true, collectionType, elementType);
    }

    public static <T> T cast(String source, boolean ignoreUnkownField, Class<?> collectionType, Class<?> ... elementType) throws IOException {
        if (ignoreUnkownField) {
            mapperIgnore.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            JavaType type = JSONUtils.getCollectionType(collectionType, elementType);
            Object result = mapperIgnore.readValue(source, type);
            return (T)result;
        }
        JavaType type = JSONUtils.getCollectionType(collectionType, elementType);
        Object result = mapper.readValue(source, type);
        return (T)result;
    }

    public static JavaType getCollectionType(Class<?> collectionClass, Class<?> ... elementClasses) {
        return mapper.getTypeFactory().constructParametricType(collectionClass, (Class[])elementClasses);
    }

    public static String getEmpty() {
        return "{}";
    }

    public static String nullDataToEmptyList(String sHttpResponse) throws Exception {
        if (StringUtils.isBlank(sHttpResponse)) {
            return sHttpResponse;
        }
        Map resMap = JSONUtils.cast(sHttpResponse, HashMap.class, true);
        if (resMap != null && StringUtils.isBlank((String)resMap.get("data"))) {
            resMap.put("data", new ArrayList());
            return JSONUtils.toString(resMap);
        }
        return sHttpResponse;
    }
}

