/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

public final class JavaVersion {
    private static final int majorJavaVersion = JavaVersion.determineMajorJavaVersion();

    private static int determineMajorJavaVersion() {
        String javaVersion = System.getProperty("java.version");
        return JavaVersion.getMajorJavaVersion(javaVersion);
    }

    static int getMajorJavaVersion(String javaVersion) {
        int version = JavaVersion.parseDotted(javaVersion);
        if (version == -1) {
            version = JavaVersion.extractBeginningInt(javaVersion);
        }
        return version == -1 ? 6 : version;
    }

    private static int parseDotted(String javaVersion) {
        try {
            String[] e = javaVersion.split("[._]");
            int firstVer = Integer.parseInt(e[0]);
            return firstVer == 1 && e.length > 1 ? Integer.parseInt(e[1]) : firstVer;
        }
        catch (NumberFormatException arg2) {
            return -1;
        }
    }

    private static int extractBeginningInt(String javaVersion) {
        try {
            char c;
            StringBuilder e = new StringBuilder();
            for (int i = 0; i < javaVersion.length() && Character.isDigit(c = javaVersion.charAt(i)); ++i) {
                e.append(c);
            }
            return Integer.parseInt(e.toString());
        }
        catch (NumberFormatException arg3) {
            return -1;
        }
    }

    public static int getMajorJavaVersion() {
        return majorJavaVersion;
    }

    public static boolean isJava17OrLater() {
        return majorJavaVersion >= 17;
    }
}

