/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import kd.bos.util.SystemProperties;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang3.SystemUtils;

@SdkPublic
public class NetAddressUtils {
    private static final boolean isPreferIPv6 = Boolean.parseBoolean(SystemProperties.getWithEnv("java.net.preferIPv6Addresses"));
    private static volatile String sLocalIP;
    private static String sLocalHostName;
    private static InetAddress inet4Address;
    private static InetAddress inet6Address;

    private static synchronized void init() {
        if (isPreferIPv6 ? inet6Address != null : inet4Address != null) {
            return;
        }
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            if (!SystemUtils.IS_OS_WINDOWS) {
                ArrayList<NetworkInterface> netIFs = Collections.list(networkInterfaces);
                Collections.reverse(netIFs);
                networkInterfaces = Collections.enumeration(netIFs);
            }
            block2: while (networkInterfaces.hasMoreElements()) {
                NetworkInterface ni = networkInterfaces.nextElement();
                if (!NetAddressUtils.isValidNI(ni)) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (isPreferIPv6) {
                        if (!NetAddressUtils.isValidV6Address(address)) continue;
                        inet6Address = address;
                        continue block2;
                    }
                    if (!NetAddressUtils.isValidV4Address(address)) continue;
                    inet4Address = address;
                    continue block2;
                }
            }
            if (isPreferIPv6) {
                int delim;
                if (inet6Address == null) {
                    inet6Address = InetAddress.getLocalHost();
                }
                sLocalIP = (delim = (sLocalIP = inet6Address.getHostAddress()).indexOf(37)) < 0 ? sLocalIP : sLocalIP.substring(0, delim);
                sLocalHostName = inet6Address.getHostName();
            } else {
                if (inet4Address == null) {
                    inet4Address = InetAddress.getLocalHost();
                }
                sLocalIP = inet4Address.getHostAddress();
                sLocalHostName = inet4Address.getHostName();
            }
        }
        catch (IOException e) {
            throw new Error("Can't get ip address.", e);
        }
    }

    public static boolean isPreferIPv6() {
        return isPreferIPv6;
    }

    public static String getLocalIpAddress() {
        if (sLocalIP != null) {
            return sLocalIP;
        }
        NetAddressUtils.init();
        return sLocalIP;
    }

    public static synchronized String getLocalHostName() {
        NetAddressUtils.init();
        return sLocalHostName;
    }

    private static boolean isValidNI(NetworkInterface ni) throws SocketException {
        return !ni.isLoopback() && ni.isUp() && !ni.getName().startsWith("docker");
    }

    private static boolean isValidV4Address(InetAddress address) throws IOException {
        return !address.isAnyLocalAddress() && !address.isLinkLocalAddress() && !address.isLoopbackAddress() && address instanceof Inet4Address;
    }

    private static boolean isValidV6Address(InetAddress address) throws IOException {
        return !address.isAnyLocalAddress() && !address.isLinkLocalAddress() && !address.isLoopbackAddress() && !address.isSiteLocalAddress() && !address.isMulticastAddress() && address instanceof Inet6Address;
    }

    public static final String getRemoteHost(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip == null || ip.length() == 0) {
            ip = "unknown";
        }
        return ip;
    }

    public static boolean isAvailable(int port) throws UnknownHostException {
        return !NetAddressUtils.isPortUsed(InetAddress.getLocalHost().getHostAddress(), port);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isPortUsed(String host, int port) {
        try (Socket s = new Socket();){
            s.connect(new InetSocketAddress(host, port), 100);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static int getAvailablePort(int startPort) throws IOException {
        for (int i = startPort; i < 65535; ++i) {
            if (!NetAddressUtils.isAvailable(i)) continue;
            return i;
        }
        throw new IOException("Can't not find available port from " + startPort);
    }

    public static String getBindedHostIP() {
        String ip = System.getProperty("server.bind.ip", "0.0.0.0");
        if (ip != null && ip.length() > 0) {
            return ip;
        }
        return NetAddressUtils.getLocalIpAddress();
    }
}

