/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantConfigurationUtils {
    private static final Logger log = LoggerFactory.getLogger(TenantConfigurationUtils.class);
    private static Method getOrCreateRequestContext;
    private static Method getTenantId;
    private static final String EMPTY_STR = "";
    private static final String UNDERLINE = "_";

    public static String getProperty(String key) {
        return TenantConfigurationUtils.getProperty(key, null);
    }

    public static String getProperty(String key, String def) {
        String tenantId = TenantConfigurationUtils.getTenantId();
        return System.getProperty(tenantId + UNDERLINE + key, def);
    }

    private static String getTenantId() {
        try {
            return (String)getTenantId.invoke(getOrCreateRequestContext.invoke(null, new Object[0]), new Object[0]);
        }
        catch (Exception e) {
            return EMPTY_STR;
        }
    }

    static {
        try {
            Class<?> cls = Class.forName("kd.bos.context.RequestContext");
            getTenantId = cls.getMethod("getTenantId", new Class[0]);
            getOrCreateRequestContext = cls.getMethod("getOrCreate", new Class[0]);
        }
        catch (Exception e) {
            log.warn("TenantConfigurationUtils static error.", (Throwable)e);
        }
    }
}

