/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import kd.bos.util.StringUtils;

public class WebPortUtil {
    private static final String WEBPORT = "JETTY_WEB_PORT";

    public static String getWebPort() {
        return WebPortUtil.getWebPort(WebPortUtil.getServerPort());
    }

    public static String getWebPort(String defalutValue) {
        String port = WebPortUtil.getProperty("webserver.port", null);
        if (StringUtils.isEmpty(port)) {
            port = WebPortUtil.getProperty(WEBPORT, null);
        }
        if (port == null) {
            port = WebPortUtil.getProperty("WEB_PORT", defalutValue);
        }
        return port;
    }

    public static String getServerPort() {
        return WebPortUtil.getProperty("server.port", "8080");
    }

    public static String setWebPort(String port) {
        System.setProperty("webserver.port", port);
        return System.setProperty(WEBPORT, port);
    }

    public static void setWebPortIfEmpty(String port) {
        if (WebPortUtil.getWebPort(null) == null) {
            WebPortUtil.setWebPort(port);
        }
    }

    private static String getProperty(String key, String defaultValue) {
        String value = System.getProperty(key);
        if (value != null) {
            return value;
        }
        value = System.getenv(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static boolean isWebNode() {
        return Boolean.getBoolean("isWebNode");
    }
}

