/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util.async;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import kd.bos.thread.ThreadEndClear;
import kd.bos.util.async.SetQueue;
import kd.bos.util.async.WrapperTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncOutput<T> {
    private Map<Long, Runnable> runnableMaps = new ConcurrentHashMap<Long, Runnable>();
    private SetQueue<Runnable> queue = new SetQueue();
    private Map<Long, ConcurrentLinkedQueue<T>> spanMaps = new ConcurrentHashMap<Long, ConcurrentLinkedQueue<T>>();
    private AtomicInteger totalSpanCount = new AtomicInteger(0);
    private AtomicLong discardTotalCount = new AtomicLong(0L);
    private int maxTotalQueueCount = Integer.MAX_VALUE;
    private boolean isWaitWhenFull = false;
    private boolean isStartedFlag = true;
    private Consumer<List<T>> consumer;
    private static final Logger log = LoggerFactory.getLogger(AsyncOutput.class);
    private static final Map<String, AsyncOutput<?>> ayncTasks = new ConcurrentHashMap(2);

    public static <J> AsyncOutput<J> create(String asyncTaskName, int outThreadCount, Consumer<List<J>> consumer) {
        return ayncTasks.computeIfAbsent(asyncTaskName, ket -> new AsyncOutput(asyncTaskName, outThreadCount, consumer));
    }

    private AsyncOutput(String asyncTaskName, int outThreadCount, Consumer<List<T>> consumer) {
        this.initMonitor(outThreadCount, asyncTaskName);
        this.consumer = consumer;
    }

    public AsyncOutput<T> withWaitWhenFull(boolean b) {
        this.isWaitWhenFull = b;
        return this;
    }

    public AsyncOutput<T> withMaxTotalQueueCount(int count) {
        this.maxTotalQueueCount = count;
        return this;
    }

    public boolean isStarted() {
        return this.isStartedFlag;
    }

    public void stop() {
        this.isStartedFlag = false;
    }

    private void initMonitor(int outputThreadCount, String outThreadName) {
        for (int i = 0; i < outputThreadCount; ++i) {
            Thread t = new Thread(() -> {
                while (this.isStartedFlag) {
                    try {
                        Runnable runnable = this.queue.poll();
                        if (runnable == null) continue;
                        runnable.run();
                    }
                    catch (Exception e) {
                        LockSupport.parkNanos(100000000L);
                        log.warn(outThreadName + ": run task of trace_span exception ", (Throwable)e);
                    }
                }
            }, outThreadName + "-" + i);
            t.setDaemon(true);
            t.start();
        }
        ThreadEndClear.addListener(threadidSet -> {
            ArrayList remove = new ArrayList();
            this.spanMaps.forEach((k, v) -> {
                if (!threadidSet.contains(k)) {
                    remove.add(k);
                }
            });
            remove.forEach(k -> this.spanMaps.remove(k));
            remove.clear();
            this.runnableMaps.forEach((k, v) -> {
                if (!threadidSet.contains(k)) {
                    remove.add(k);
                }
            });
            remove.forEach(k -> this.runnableMaps.remove(k));
        });
    }

    public void onEvent(T o) {
        long threadId = Thread.currentThread().getId();
        ConcurrentLinkedQueue spanLs = this.spanMaps.computeIfAbsent(threadId, k -> {
            ConcurrentLinkedQueue q = new ConcurrentLinkedQueue();
            this.runnableMaps.put(threadId, new WrapperTask<T>(threadId, this.spanMaps, this.totalSpanCount, this.consumer));
            return q;
        });
        this.queue.putIfAbsent(this.runnableMaps.get(threadId));
        if (this.isWaitWhenFull) {
            while (this.totalSpanCount.get() > this.maxTotalQueueCount) {
                LockSupport.parkNanos(50000000L);
            }
        } else if (this.totalSpanCount.get() > this.maxTotalQueueCount) {
            this.discardTotalCount.incrementAndGet();
            return;
        }
        spanLs.add(o);
        this.totalSpanCount.incrementAndGet();
    }

    public long getDiscardCount() {
        return this.discardTotalCount.get();
    }
}

