/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util.hint;

import kd.bos.util.ThreadLocals;

public class SQLHintContext
implements AutoCloseable {
    private static final ThreadLocal<SQLHintContext> thCtx = ThreadLocals.create();
    private SQLHintContext parent = thCtx.get();
    private String hint;

    private SQLHintContext(String hint) {
        this.hint = hint;
        thCtx.set(this);
    }

    public static SQLHintContext createQingHint() {
        return SQLHintContext.createHint(HintComment.QING_HINT);
    }

    public static SQLHintContext createQueryAnalyzerHint() {
        return SQLHintContext.createHint(HintComment.QUERY_ANALYZER_HINT);
    }

    public static SQLHintContext createDBReadOnlyHint() {
        return SQLHintContext.createHint(HintComment.DB_READ_ONLY_HINT);
    }

    private static SQLHintContext createHint(HintComment hint) {
        return new SQLHintContext(hint.getHint());
    }

    public static SQLHintContext get() {
        return thCtx.get();
    }

    public SQLHintContext getParent() {
        return this.parent;
    }

    public String getHint() {
        return this.hint;
    }

    @Override
    public void close() {
        if (this.parent == null) {
            thCtx.remove();
        } else {
            thCtx.set(this.parent);
        }
    }

    static enum HintComment {
        QING_HINT("/*qing*/"),
        QUERY_ANALYZER_HINT("/*query_analyzer*/"),
        DB_READ_ONLY_HINT("/*read_only*/");

        String hint;

        private HintComment(String hint) {
            this.hint = hint;
        }

        String getHint() {
            return this.hint;
        }
    }
}

