/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.zip.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import kd.bos.zip.headers.HeaderUtil;
import kd.bos.zip.io.inputstream.SplitInputStream;
import kd.bos.zip.io.inputstream.ZipInputStream;
import kd.bos.zip.model.FileHeader;
import kd.bos.zip.model.UnzipParameters;
import kd.bos.zip.model.Zip4jConfig;
import kd.bos.zip.model.ZipModel;
import kd.bos.zip.progress.ProgressMonitor;
import kd.bos.zip.tasks.AbstractExtractFileTask;
import kd.bos.zip.tasks.AbstractZipTaskParameters;
import kd.bos.zip.tasks.AsyncZipTask;
import kd.bos.zip.util.UnzipUtil;
import kd.bos.zip.util.Zip4jUtil;

public class ExtractFileTask
extends AbstractExtractFileTask<ExtractFileTaskParameters> {
    private char[] password;
    private SplitInputStream splitInputStream;

    public ExtractFileTask(ZipModel zipModel, char[] password, UnzipParameters unzipParameters, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(zipModel, unzipParameters, asyncTaskParameters);
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeTask(ExtractFileTaskParameters taskParameters, ProgressMonitor progressMonitor) throws IOException {
        try (ZipInputStream zipInputStream = this.createZipInputStream(taskParameters.fileHeader, taskParameters.zip4jConfig);){
            List<FileHeader> fileHeadersUnderDirectory = this.getFileHeadersToExtract(taskParameters.fileHeader);
            byte[] readBuff = new byte[taskParameters.zip4jConfig.getBufferSize()];
            for (FileHeader fileHeader : fileHeadersUnderDirectory) {
                String newFileName = this.determineNewFileName(taskParameters.newFileName, taskParameters.fileHeader, fileHeader);
                this.extractFile(zipInputStream, fileHeader, taskParameters.outputPath, newFileName, progressMonitor, readBuff);
            }
        }
        finally {
            if (this.splitInputStream != null) {
                this.splitInputStream.close();
            }
        }
    }

    @Override
    protected long calculateTotalWork(ExtractFileTaskParameters taskParameters) {
        List<FileHeader> fileHeadersUnderDirectory = this.getFileHeadersToExtract(taskParameters.fileHeader);
        return HeaderUtil.getTotalUncompressedSizeOfAllFileHeaders(fileHeadersUnderDirectory);
    }

    private List<FileHeader> getFileHeadersToExtract(FileHeader rootFileHeader) {
        if (!rootFileHeader.isDirectory()) {
            return Collections.singletonList(rootFileHeader);
        }
        return HeaderUtil.getFileHeadersUnderDirectory(this.getZipModel().getCentralDirectory().getFileHeaders(), rootFileHeader);
    }

    private ZipInputStream createZipInputStream(FileHeader fileHeader, Zip4jConfig zip4jConfig) throws IOException {
        this.splitInputStream = UnzipUtil.createSplitInputStream(this.getZipModel());
        this.splitInputStream.prepareExtractionForFileHeader(fileHeader);
        return new ZipInputStream((InputStream)this.splitInputStream, this.password, zip4jConfig);
    }

    private String determineNewFileName(String newFileName, FileHeader fileHeaderToExtract, FileHeader fileHeaderBeingExtracted) {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(newFileName)) {
            return newFileName;
        }
        if (!fileHeaderToExtract.isDirectory()) {
            return newFileName;
        }
        String fileSeparator = "/";
        if (newFileName.endsWith("/")) {
            fileSeparator = "";
        }
        return fileHeaderBeingExtracted.getFileName().replaceFirst(fileHeaderToExtract.getFileName(), newFileName + fileSeparator);
    }

    public static class ExtractFileTaskParameters
    extends AbstractZipTaskParameters {
        private String outputPath;
        private FileHeader fileHeader;
        private String newFileName;

        public ExtractFileTaskParameters(String outputPath, FileHeader fileHeader, String newFileName, Zip4jConfig zip4jConfig) {
            super(zip4jConfig);
            this.outputPath = outputPath;
            this.fileHeader = fileHeader;
            this.newFileName = newFileName;
        }
    }
}

