/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.zip.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import kd.bos.zip.exception.ZipException;
import kd.bos.zip.io.inputstream.NumberedSplitInputStream;
import kd.bos.zip.io.inputstream.SplitInputStream;
import kd.bos.zip.io.inputstream.ZipInputStream;
import kd.bos.zip.io.inputstream.ZipStandardSplitInputStream;
import kd.bos.zip.model.FileHeader;
import kd.bos.zip.model.ZipModel;
import kd.bos.zip.util.FileUtils;

public class UnzipUtil {
    public static ZipInputStream createZipInputStream(ZipModel zipModel, FileHeader fileHeader, char[] password) throws IOException {
        SplitInputStream splitInputStream = null;
        try {
            splitInputStream = UnzipUtil.createSplitInputStream(zipModel);
            splitInputStream.prepareExtractionForFileHeader(fileHeader);
            ZipInputStream zipInputStream = new ZipInputStream((InputStream)splitInputStream, password);
            if (zipInputStream.getNextEntry(fileHeader) == null) {
                throw new ZipException("Could not locate local file header for corresponding file header");
            }
            return zipInputStream;
        }
        catch (IOException e) {
            if (splitInputStream != null) {
                splitInputStream.close();
            }
            throw e;
        }
    }

    public static void applyFileAttributes(FileHeader fileHeader, File file) {
        try {
            Path path = file.toPath();
            FileUtils.setFileAttributes(path, fileHeader.getExternalFileAttributes());
            FileUtils.setFileLastModifiedTime(path, fileHeader.getLastModifiedTime());
        }
        catch (NoSuchMethodError e) {
            FileUtils.setFileLastModifiedTimeWithoutNio(file, fileHeader.getLastModifiedTime());
        }
    }

    public static SplitInputStream createSplitInputStream(ZipModel zipModel) throws IOException {
        File zipFile = zipModel.getZipFile();
        if (zipFile.getName().endsWith(".zip.001")) {
            return new NumberedSplitInputStream(zipModel.getZipFile(), true, zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk());
        }
        return new ZipStandardSplitInputStream(zipModel.getZipFile(), zipModel.isSplitArchive(), zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk());
    }
}

