/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.zip.util;

import kd.bos.zip.headers.VersionMadeBy;
import kd.bos.zip.headers.VersionNeededToExtract;
import kd.bos.zip.model.ZipParameters;
import kd.bos.zip.model.enums.CompressionMethod;
import kd.bos.zip.model.enums.EncryptionMethod;
import kd.bos.zip.util.FileUtils;
import kd.bos.zip.util.RawIO;

public class ZipVersionUtils {
    public static int determineVersionMadeBy(ZipParameters zipParameters, RawIO rawIO) {
        byte[] versionMadeBy = new byte[]{VersionMadeBy.SPECIFICATION_VERSION.getCode(), VersionMadeBy.UNIX.getCode()};
        if (FileUtils.isWindows() && !zipParameters.isUnixMode()) {
            versionMadeBy[1] = VersionMadeBy.WINDOWS.getCode();
        }
        return rawIO.readShortLittleEndian(versionMadeBy, 0);
    }

    public static VersionNeededToExtract determineVersionNeededToExtract(ZipParameters zipParameters) {
        VersionNeededToExtract versionRequired = VersionNeededToExtract.DEFAULT;
        if (zipParameters.getCompressionMethod() == CompressionMethod.DEFLATE) {
            versionRequired = VersionNeededToExtract.DEFLATE_COMPRESSED;
        }
        if (zipParameters.getEntrySize() > 0xFFFFFFFFL) {
            versionRequired = VersionNeededToExtract.ZIP_64_FORMAT;
        }
        if (zipParameters.isEncryptFiles() && zipParameters.getEncryptionMethod().equals((Object)EncryptionMethod.AES)) {
            versionRequired = VersionNeededToExtract.AES_ENCRYPTED;
        }
        return versionRequired;
    }
}

