/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elasticsearch.api.impl;

import java.io.IOException;
import kd.bos.elasticsearch.client.ESRestClient;
import kd.bos.elasticsearch.config.ESConfig;
import kd.bos.elasticsearch.factory.ESClientFactory;
import kd.bos.elasticsearch.request.ESRequest;
import kd.bos.elasticsearch.response.ESResponse;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;

abstract class AbstractESAction<T> {
    private ESRestClient esClient;
    protected static final Log logger = LogFactory.getLog((String)"AbstractESAction");

    public AbstractESAction(ESConfig config) {
        this.esClient = ESClientFactory.getClient(config);
    }

    public AbstractESAction(RestClient restClient) {
        this.esClient = new ESRestClient(restClient);
    }

    public T execute() {
        ESRequest esRequest = this.build();
        Class responseDataCls = this.getResponseDataCls();
        ESResponse esResponse = this.executeInternal(esRequest, responseDataCls);
        return this.parse(esResponse, esRequest, responseDataCls);
    }

    public int getServerVersion() {
        return this.esClient.getServerVersion();
    }

    protected ESResponse executeInternal(ESRequest esRequest, Class responseDataCls) {
        ESResponse esResponse = null;
        try {
            Response response = this.esClient.execute(esRequest.toESRestRequest());
            String rspString = null;
            HttpEntity httpEntity = response.getEntity();
            if (httpEntity != null) {
                rspString = EntityUtils.toString((HttpEntity)httpEntity);
            }
            esResponse = response.getStatusLine().getStatusCode() == 200 ? new ESResponse(true, "success", null, rspString, null, response.getStatusLine(), response.getHost(), responseDataCls) : new ESResponse(false, "fail,status code: " + response.getStatusLine().getStatusCode(), null, rspString, null, response.getStatusLine(), response.getHost(), responseDataCls);
        }
        catch (IOException | IllegalStateException e) {
            logger.error("execute es request error", (Throwable)e);
            if (e instanceof ResponseException) {
                Response response = ((ResponseException)e).getResponse();
                String respString = null;
                try {
                    respString = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                esResponse = new ESResponse(false, e.getMessage(), e, respString, null, response.getStatusLine(), null, responseDataCls);
            }
            esResponse = new ESResponse(false, e.getMessage(), e, null, null, null, null, responseDataCls);
        }
        return esResponse;
    }

    protected Void retry(ESResponse esResponse, ESRequest esRequest, Class responseDataCls) {
        if (!esResponse.isOk()) {
            this.retry0(esRequest, responseDataCls);
        }
        return null;
    }

    protected void retry0(ESRequest esRequest, Class responseDataCls) {
        ESResponse esResponse;
        int retrySize = Integer.parseInt(System.getProperty("elasticsearch.retry", "5"));
        for (int i = 0; i < retrySize && !(esResponse = this.executeInternal(esRequest, responseDataCls)).isOk(); ++i) {
        }
    }

    protected abstract T parse(ESResponse var1, ESRequest var2, Class var3);

    protected abstract Class getResponseDataCls();

    protected abstract ESRequest build();
}

