/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elasticsearch.api.impl;

import java.util.HashMap;
import java.util.Map;
import kd.bos.elasticsearch.api.impl.AbstractESAction;
import kd.bos.elasticsearch.config.ESConfig;
import kd.bos.elasticsearch.request.CreateIndexRequest;
import kd.bos.elasticsearch.request.ESRequest;
import kd.bos.elasticsearch.request.Mapping;
import kd.bos.elasticsearch.request.Settings;
import kd.bos.elasticsearch.response.CreaIndexResponse;
import kd.bos.elasticsearch.response.ESResponse;
import org.elasticsearch.client.RestClient;

class CreateIndexAction
extends AbstractESAction<Void> {
    private String index;
    private Mapping mapping;
    private Settings settings;

    public CreateIndexAction(ESConfig config, String index, Mapping mapping, Settings settings) {
        super(config);
        this.index = index;
        this.mapping = mapping;
        this.settings = settings;
    }

    public CreateIndexAction(RestClient restClient, String index, Mapping mapping, Settings settings) {
        super(restClient);
        this.index = index;
        this.mapping = mapping;
        this.settings = settings;
    }

    @Override
    protected ESRequest build() {
        return new CreateIndexRequest(this.index, this.mapping, this.settings, this.getParameters(), this.getServerVersion());
    }

    @Override
    protected Class getResponseDataCls() {
        return CreaIndexResponse.class;
    }

    @Override
    protected Void parse(ESResponse esResponse, ESRequest esRequest, Class responseDataCls) {
        if (!esResponse.isOk()) {
            if (this.indexAlreadyExists((CreaIndexResponse)esResponse.getData())) {
                return null;
            }
            this.retry0(esRequest, responseDataCls);
        }
        return null;
    }

    private Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("master_timeout", "30s");
        parameters.put("timeout", "600s");
        if (this.getServerVersion() <= 6) {
            parameters.put("include_type_name", "false");
        }
        return parameters;
    }

    private boolean indexAlreadyExists(CreaIndexResponse response) {
        if (response == null) {
            return false;
        }
        return response.getStatus() == 400 && "resource_already_exists_exception".equalsIgnoreCase(response.getError().getType());
    }
}

