/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elasticsearch.api.impl;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.elasticsearch.api.impl.AbstractESAction;
import kd.bos.elasticsearch.config.ESConfig;
import kd.bos.elasticsearch.exception.BosElasticSearchException;
import kd.bos.elasticsearch.request.DeleteRequest;
import kd.bos.elasticsearch.request.ESRequest;
import kd.bos.elasticsearch.response.DeleteResponse;
import kd.bos.elasticsearch.response.ESResponse;
import org.elasticsearch.client.RestClient;

public class DeleteAction
extends AbstractESAction<Void> {
    private String index;
    private List<Object> pks;
    private String type;

    public DeleteAction(ESConfig config, String index, List<Object> pks, String type) {
        super(config);
        this.index = index;
        this.pks = pks;
        this.type = type;
    }

    public DeleteAction(RestClient restClient, String index, List<Object> pks, String type) {
        super(restClient);
        this.index = index;
        this.pks = pks;
        this.type = type;
    }

    @Override
    protected Void parse(ESResponse esResponse, ESRequest esRequest, Class responseDataCls) {
        if (esResponse.isOk()) {
            DeleteResponse deleteResponse = (DeleteResponse)esResponse.getData();
            if (deleteResponse.getErrors().booleanValue()) {
                logger.warn("parse error:" + JSON.toJSONString((Object)deleteResponse));
                throw new BosElasticSearchException(JSON.toJSONString(deleteResponse.getItems()));
            }
            return null;
        }
        return this.retry(esResponse, esRequest, responseDataCls);
    }

    @Override
    protected Class getResponseDataCls() {
        return DeleteResponse.class;
    }

    @Override
    protected ESRequest build() {
        return new DeleteRequest(this.index, this.pks, this.getParameters(), this.getServerVersion(), this.type);
    }

    private Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("refresh", "true");
        parameters.put("timeout", "1m");
        return parameters;
    }
}

