/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elasticsearch.api.impl;

import java.util.HashMap;
import java.util.Map;
import kd.bos.elasticsearch.api.impl.AbstractESAction;
import kd.bos.elasticsearch.config.ESConfig;
import kd.bos.elasticsearch.request.DeleteDataRequest;
import kd.bos.elasticsearch.request.ESRequest;
import kd.bos.elasticsearch.response.CreaIndexResponse;
import kd.bos.elasticsearch.response.ESResponse;

class DeleteDataAction
extends AbstractESAction<Void> {
    public DeleteDataAction(ESConfig config) {
        super(config);
    }

    @Override
    protected ESRequest build() {
        return new DeleteDataRequest();
    }

    @Override
    protected Class getResponseDataCls() {
        return Void.class;
    }

    @Override
    protected Void parse(ESResponse esResponse, ESRequest esRequest, Class responseDataCls) {
        if (!esResponse.isOk()) {
            if (this.indexAlreadyExists((CreaIndexResponse)esResponse.getData())) {
                return null;
            }
            this.retry0(esRequest, responseDataCls);
        }
        return null;
    }

    private Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("master_timeout", "30s");
        parameters.put("timeout", "600s");
        if (this.getServerVersion() <= 6) {
            parameters.put("include_type_name", "false");
        }
        return parameters;
    }

    private boolean indexAlreadyExists(CreaIndexResponse response) {
        if (response == null) {
            return false;
        }
        return response.getStatus() == 400 && "resource_already_exists_exception".equalsIgnoreCase(response.getError().getType());
    }
}

