/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elasticsearch.api.impl;

import java.util.List;
import java.util.Map;
import kd.bos.elasticsearch.api.ESStorage;
import kd.bos.elasticsearch.api.impl.AddOrUpdateFieldAction;
import kd.bos.elasticsearch.api.impl.CreateIndexAction;
import kd.bos.elasticsearch.api.impl.DeleteAction;
import kd.bos.elasticsearch.api.impl.IndexExistAction;
import kd.bos.elasticsearch.api.impl.SaveAction;
import kd.bos.elasticsearch.api.impl.UpdateSettingsAction;
import kd.bos.elasticsearch.common.ESKeyMapJavaFieldEnum;
import kd.bos.elasticsearch.config.ESConfig;
import kd.bos.elasticsearch.request.ESRow;
import kd.bos.elasticsearch.request.Mapping;
import kd.bos.elasticsearch.request.Settings;
import kd.bos.elasticsearch.util.ESUtil;
import org.elasticsearch.client.RestClient;

public class ESStorageImpl
implements ESStorage {
    private String region;
    private ESConfig config;
    private RestClient restClient;

    private ESStorageImpl(ESConfig config) {
        this.config = config;
    }

    private ESStorageImpl(RestClient restClient) {
        this.restClient = restClient;
    }

    private ESStorageImpl(String region) {
        ESConfig config;
        this.region = region;
        Map<String, String> serverConfig = ESUtil.getServerConfig(region);
        this.config = config = new ESConfig(serverConfig.get("host"), serverConfig.get("username"), serverConfig.get("password"), serverConfig.get("schema"), serverConfig.get("certPath"), serverConfig.get("certPassword"));
    }

    public static ESStorage getInstance(String region) {
        return new ESStorageImpl(region);
    }

    public static ESStorage getInstance(ESConfig config) {
        return new ESStorageImpl(config);
    }

    public static ESStorage getInstance(RestClient restClient) {
        return new ESStorageImpl(restClient);
    }

    @Override
    public boolean indexExist(String index) {
        IndexExistAction action = this.restClient != null ? new IndexExistAction(this.restClient, index) : new IndexExistAction(this.config, index);
        return (Boolean)action.execute();
    }

    @Override
    public void createIndex(String index) {
        this.createIndex(index, null);
    }

    @Override
    public void createIndex(String index, Mapping mapping) {
        Settings settings = null;
        if (this.config != null) {
            Map<String, Object> settingMap = this.config.getSettings();
            if (settingMap != null && settingMap.size() > 0) {
                Object totalFieldsLimit;
                Object numberOfShards;
                Object numberOfReplicas;
                settings = Settings.build();
                Object maxResultWindow = settingMap.get(ESKeyMapJavaFieldEnum.SETTINGS_MAX_RESULT_WINDOW.getEsKey());
                if (maxResultWindow != null) {
                    settings.maxResultWindow(Integer.parseInt(maxResultWindow.toString()));
                }
                if ((numberOfReplicas = settingMap.get(ESKeyMapJavaFieldEnum.SETTINGS_NUMBER_OF_REPLICAS.getEsKey())) != null) {
                    settings.numberOfReplicas(Integer.parseInt(numberOfReplicas.toString()));
                }
                if ((numberOfShards = settingMap.get(ESKeyMapJavaFieldEnum.SETTINGS_NUMBER_OF_SHARDS.getEsKey())) != null) {
                    settings.numberOfShards(Integer.parseInt(numberOfShards.toString()));
                }
                if ((totalFieldsLimit = settingMap.get(ESKeyMapJavaFieldEnum.SETTINGS_TOTAL_FIELDS_LIMIT.getEsKey())) != null) {
                    settings.totalFieldsLimit(Integer.parseInt(totalFieldsLimit.toString()));
                }
            }
        } else if (this.region != null && this.region.length() > 0) {
            settings = ESUtil.getIndexSettings(this.region);
        }
        this.createIndex(index, mapping, settings);
    }

    @Override
    public void createIndex(String index, Mapping mapping, Settings settings) {
        CreateIndexAction action = this.restClient != null ? new CreateIndexAction(this.restClient, index, mapping, settings) : new CreateIndexAction(this.config, index, mapping, settings);
        action.execute();
    }

    @Override
    public void addOrUpdateField(String index, Mapping mapping) {
        AddOrUpdateFieldAction action = this.restClient != null ? new AddOrUpdateFieldAction(this.restClient, index, mapping) : new AddOrUpdateFieldAction(this.config, index, mapping);
        action.execute();
    }

    @Override
    public void updateSetting(String index, Settings settings) {
        UpdateSettingsAction action = this.restClient != null ? new UpdateSettingsAction(this.restClient, index, settings) : new UpdateSettingsAction(this.config, index, settings);
        action.execute();
    }

    @Override
    public void save(String index, String type, List<ESRow> rows) {
        SaveAction action = this.restClient != null ? new SaveAction(this.restClient, index, rows, type) : new SaveAction(this.config, index, rows, type);
        action.execute();
    }

    @Override
    public void deleteByPk(String index, String type, List<Object> pks) {
        DeleteAction action = this.restClient != null ? new DeleteAction(this.restClient, index, pks, type) : new DeleteAction(this.config, index, pks, type);
        action.execute();
    }
}

