/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elasticsearch.api.impl;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.elasticsearch.api.impl.AbstractESAction;
import kd.bos.elasticsearch.config.ESConfig;
import kd.bos.elasticsearch.exception.BosElasticSearchException;
import kd.bos.elasticsearch.request.ESRequest;
import kd.bos.elasticsearch.request.ESRow;
import kd.bos.elasticsearch.request.SaveRequest;
import kd.bos.elasticsearch.response.ESResponse;
import kd.bos.elasticsearch.response.SaveResponse;
import org.elasticsearch.client.RestClient;

public class SaveAction
extends AbstractESAction<Void> {
    private String index;
    private List<ESRow> rows;
    private String type;

    public SaveAction(ESConfig config, String index, List<ESRow> rows, String type) {
        super(config);
        this.index = index;
        this.rows = rows;
        this.type = type;
    }

    public SaveAction(RestClient restClient, String index, List<ESRow> rows, String type) {
        super(restClient);
        this.index = index;
        this.rows = rows;
        this.type = type;
    }

    @Override
    protected Void parse(ESResponse esResponse, ESRequest esRequest, Class responseDataCls) {
        if (esResponse.isOk()) {
            SaveResponse saveResponse = (SaveResponse)esResponse.getData();
            if (saveResponse.getErrors().booleanValue()) {
                throw new BosElasticSearchException(JSON.toJSONString(saveResponse.getItems()));
            }
            return null;
        }
        return this.retry(esResponse, esRequest, responseDataCls);
    }

    @Override
    protected Class getResponseDataCls() {
        return SaveResponse.class;
    }

    @Override
    protected ESRequest build() {
        return new SaveRequest(this.index, this.rows, this.getParameters(), this.getServerVersion(), this.type);
    }

    private Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("refresh", "true");
        parameters.put("timeout", "600s");
        return parameters;
    }
}

