/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elasticsearch.factory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.elasticsearch.client.ESRestClient;
import kd.bos.elasticsearch.config.ESConfig;
import kd.bos.elasticsearch.util.ESUtil;

public class ESClientFactory {
    private static final Map<String, ESRestClient> clientMap = new ConcurrentHashMap<String, ESRestClient>();

    public static ESRestClient getClient(ESConfig config) {
        ESRestClient newClient;
        String key = config.getKey();
        ESRestClient esClient = clientMap.get(key);
        if (esClient == null && (newClient = clientMap.putIfAbsent(key, esClient = new ESRestClient(config))) != null) {
            try {
                if (esClient != null) {
                    esClient.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return esClient;
    }

    public static ESRestClient getClient(String region) {
        Map<String, String> serverConfig = ESUtil.getServerConfig(region);
        ESConfig config = new ESConfig(serverConfig.get("host"), serverConfig.get("username"), serverConfig.get("password"));
        return ESClientFactory.getClient(config);
    }

    public static void clearClient(ESConfig config) {
        clientMap.remove(config.getKey());
    }

    public static void clearClient(String region) {
        Map<String, String> serverConfig = ESUtil.getServerConfig(region);
        ESConfig config = new ESConfig(serverConfig.get("host"), serverConfig.get("username"), serverConfig.get("password"));
        clientMap.remove(config.getKey());
    }
}

