/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elasticsearch.request;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import kd.bos.elasticsearch.request.ESProperty;
import kd.bos.elasticsearch.request.ESRequest;
import kd.bos.elasticsearch.request.Mapping;

public class AddOrUpdateFieldRequest
extends ESRequest {
    public AddOrUpdateFieldRequest(String index, Mapping mapping, Map<String, String> params, int esServerVersion) {
        String endpointPrefix = index + "/_mapping";
        this.endpoint = esServerVersion <= 6 ? endpointPrefix + "/" + mapping.getType() : endpointPrefix;
        this.data = this.createData(mapping);
        this.requestType = ESRequest.RequestType.PUT;
        this.contentType = ESRequest.ContentType.JSON;
        this.params = params;
    }

    private String createData(Mapping mapping) {
        List<ESProperty> properties;
        JSONObject data = new JSONObject();
        if (mapping != null && (properties = mapping.getProperties()) != null && properties.size() > 0) {
            JSONObject propertiesJson = new JSONObject();
            for (ESProperty esProperty : properties) {
                propertiesJson.put(esProperty.getName(), (Object)esProperty.toFieldJson());
            }
            data.put("properties", (Object)propertiesJson);
        }
        return data.toJSONString();
    }
}

