/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elasticsearch.request;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import kd.bos.elasticsearch.common.ESKeyMapJavaFieldEnum;
import kd.bos.elasticsearch.request.ESProperty;
import kd.bos.elasticsearch.request.ESRequest;
import kd.bos.elasticsearch.request.Mapping;
import kd.bos.elasticsearch.request.Settings;

public class CreateIndexRequest
extends ESRequest {
    public CreateIndexRequest(String index, Mapping mapping, Settings settings, Map<String, String> params, int esServerVersion) {
        this.endpoint = index;
        this.data = this.createData(mapping, settings, esServerVersion);
        this.requestType = ESRequest.RequestType.PUT;
        this.contentType = ESRequest.ContentType.JSON;
        this.params = params;
    }

    private String createData(Mapping mapping, Settings settings, int esServerVersion) {
        JSONObject data = new JSONObject();
        if (settings != null) {
            JSONObject settingsJson = new JSONObject();
            if (settings.getMaxResultWindow() != null) {
                settingsJson.put(ESKeyMapJavaFieldEnum.SETTINGS_MAX_RESULT_WINDOW.getEsKey(), (Object)settings.getMaxResultWindow());
            }
            if (settings.getNumberOfReplicas() != null) {
                settingsJson.put(ESKeyMapJavaFieldEnum.SETTINGS_NUMBER_OF_REPLICAS.getEsKey(), (Object)settings.getNumberOfReplicas());
            }
            if (settings.getNumberOfShards() != null) {
                settingsJson.put(ESKeyMapJavaFieldEnum.SETTINGS_NUMBER_OF_SHARDS.getEsKey(), (Object)settings.getNumberOfShards());
            }
            if (settings.getTotalFieldsLimit() != null) {
                settingsJson.put(ESKeyMapJavaFieldEnum.SETTINGS_TOTAL_FIELDS_LIMIT.getEsKey(), (Object)settings.getTotalFieldsLimit());
            }
            data.put("settings", (Object)settingsJson);
        }
        if (mapping != null) {
            JSONObject mappingJson = new JSONObject();
            List<ESProperty> properties = mapping.getProperties();
            if (properties != null && properties.size() > 0) {
                JSONObject propertiesJson = new JSONObject();
                for (ESProperty esProperty : properties) {
                    propertiesJson.put(esProperty.getName(), (Object)esProperty.toFieldJson());
                }
                if (esServerVersion <= 6) {
                    JSONObject typeJson = new JSONObject();
                    typeJson.put("properties", properties);
                    mappingJson.put(mapping.getType(), (Object)typeJson);
                } else {
                    mappingJson.put("properties", (Object)propertiesJson);
                }
            }
            data.put("mapping", (Object)mappingJson);
        }
        return data.toJSONString();
    }
}

