/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elasticsearch.request;

import java.util.Map;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;

public abstract class ESRequest {
    protected String endpoint;
    protected RequestType requestType;
    protected ContentType contentType;
    protected String data;
    protected Map<String, String> header;
    protected Map<String, String> params;

    protected ESRequest() {
    }

    protected ESRequest(String endpoint, RequestType requestType, ContentType contentType) {
        this.endpoint = endpoint;
        this.requestType = requestType;
        this.contentType = contentType;
    }

    protected ESRequest(String endpoint, RequestType requestType, ContentType contentType, String data) {
        this.endpoint = endpoint;
        this.requestType = requestType;
        this.contentType = contentType;
        this.data = data;
    }

    protected ESRequest(String endpoint, RequestType requestType, ContentType contentType, Map<String, String> params, Map<String, String> header) {
        this.endpoint = endpoint;
        this.requestType = requestType;
        this.contentType = contentType;
        this.params = params;
        this.header = header;
    }

    protected ESRequest(String endpoint, RequestType requestType, ContentType contentType, String data, Map<String, String> params, Map<String, String> header) {
        this.endpoint = endpoint;
        this.requestType = requestType;
        this.contentType = contentType;
        this.params = params;
        this.header = header;
        this.data = data;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public String getData() {
        return this.data;
    }

    public Map<String, String> getHeader() {
        return this.header;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    protected boolean validate() {
        return true;
    }

    public Request toESRestRequest() {
        Request inner = new Request(this.requestType.name(), this.endpoint);
        RequestOptions.Builder reqOpsBuilder = RequestOptions.DEFAULT.toBuilder();
        if (this.header != null) {
            this.header.forEach((arg_0, arg_1) -> ((RequestOptions.Builder)reqOpsBuilder).addHeader(arg_0, arg_1));
            inner.setOptions(reqOpsBuilder);
        }
        if (this.params != null) {
            this.params.forEach((arg_0, arg_1) -> ((Request)inner).addParameter(arg_0, arg_1));
        }
        if (this.data != null) {
            inner.setJsonEntity(this.data);
        }
        return inner;
    }

    public static enum ContentType {
        JSON;

    }

    public static enum RequestType {
        PUT,
        GET,
        POST,
        HEAD;

    }
}

