/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elasticsearch.request;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import kd.bos.elasticsearch.request.ESColumn;
import kd.bos.elasticsearch.request.ESRequest;
import kd.bos.elasticsearch.request.ESRow;

public class SaveRequest
extends ESRequest {
    public SaveRequest(String index, List<ESRow> rows, Map<String, String> params, int esServerVersion, String type) {
        this.endpoint = index + "/_bulk";
        this.data = this.createData(index, rows, esServerVersion, type);
        this.requestType = ESRequest.RequestType.POST;
        this.contentType = ESRequest.ContentType.JSON;
        this.params = params;
    }

    private String createData(String index, List<ESRow> rows, int esServerVersion, String type) {
        StringBuilder builder = new StringBuilder();
        if (rows != null && rows.size() > 0) {
            int count = 0;
            for (ESRow esRow : rows) {
                ESColumn pkColumn;
                JSONObject updateJson = new JSONObject();
                JSONObject indexJson = new JSONObject();
                indexJson.put("_index", (Object)index);
                if (esServerVersion <= 6) {
                    indexJson.put("_type", (Object)type);
                }
                if ((pkColumn = esRow.getPkColumn()) != null) {
                    indexJson.put("_id", pkColumn.getColumnValue());
                }
                indexJson.put("retry_on_conflict", (Object)5);
                updateJson.put("update", (Object)indexJson);
                builder.append(updateJson.toJSONString());
                List<ESColumn> columns = esRow.getColumns();
                if (columns != null && columns.size() > 0) {
                    JSONObject data = new JSONObject();
                    JSONObject docJson = new JSONObject();
                    JSONObject upsertJson = new JSONObject();
                    for (ESColumn esColumn : columns) {
                        docJson.put(esColumn.getColumnName(), esColumn.getColumnValue());
                        upsertJson.put(esColumn.getColumnName(), esColumn.getColumnValue());
                    }
                    data.put("doc", (Object)docJson);
                    data.put("upsert", (Object)upsertJson);
                    builder.append("\n");
                    builder.append(data.toJSONString());
                    builder.append("\n");
                }
                ++count;
            }
        }
        return builder.toString();
    }
}

