/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elasticsearch.request;

import com.alibaba.fastjson.JSONObject;

public class Settings {
    private Integer totalFieldsLimit;
    private Integer numberOfReplicas;
    private Integer numberOfShards;
    private Integer maxResultWindow;

    private Settings() {
    }

    public static Settings build() {
        return new Settings();
    }

    public Settings totalFieldsLimit(Integer totalFieldsLimit) {
        this.totalFieldsLimit = totalFieldsLimit;
        return this;
    }

    public Settings numberOfReplicas(Integer numberOfReplicas) {
        this.numberOfReplicas = numberOfReplicas;
        return this;
    }

    public Settings numberOfShards(Integer numberOfShards) {
        this.numberOfShards = numberOfShards;
        return this;
    }

    public Settings maxResultWindow(Integer maxResultWindow) {
        this.maxResultWindow = maxResultWindow;
        return this;
    }

    public Integer getTotalFieldsLimit() {
        return this.totalFieldsLimit;
    }

    public Integer getNumberOfReplicas() {
        return this.numberOfReplicas;
    }

    public Integer getNumberOfShards() {
        return this.numberOfShards;
    }

    public Integer getMaxResultWindow() {
        return this.maxResultWindow;
    }

    public JSONObject toJsonObject(int esVersion) {
        JSONObject index = new JSONObject();
        if (esVersion <= 6) {
            if (this.getTotalFieldsLimit() != null) {
                JSONObject mapping = new JSONObject();
                JSONObject totalFields = new JSONObject();
                totalFields.put("limit", (Object)this.getTotalFieldsLimit());
                mapping.put("total_fields", (Object)totalFields);
                JSONObject innerIndex = new JSONObject();
                innerIndex.put("mapping", (Object)mapping);
                index.put("index", (Object)innerIndex);
            }
        } else if (this.getTotalFieldsLimit() != null) {
            JSONObject mapping = new JSONObject();
            JSONObject totalFields = new JSONObject();
            totalFields.put("limit", (Object)this.getTotalFieldsLimit());
            mapping.put("total_fields", (Object)totalFields);
            index.put("mapping", (Object)mapping);
        }
        if (this.getNumberOfShards() != null && esVersion <= 6) {
            index.put("number_of_shards", (Object)this.getNumberOfShards());
        }
        if (this.getNumberOfReplicas() != null) {
            index.put("number_of_replicas", (Object)this.getNumberOfReplicas());
        }
        if (this.getMaxResultWindow() != null) {
            index.put("max_result_window", (Object)this.getMaxResultWindow());
        }
        return index;
    }
}

