/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.elasticsearch.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kd.bos.elasticsearch.common.ESKeyMapJavaFieldEnum;
import kd.bos.elasticsearch.request.Settings;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.StringUtils;
import org.apache.http.HttpHost;

public class ESUtil {
    public static Map<String, String> getServerConfig(String region) {
        String password;
        String key = "elasticsearch.server." + region;
        String value = System.getProperty(key);
        if (StringUtils.isEmpty((String)value)) {
            throw new KDException(BosErrorCode.bosElasticSearch, new Object[]{key + " the fulltext service is not configured."});
        }
        HashMap<String, String> result = new HashMap<String, String>();
        Properties prop = new Properties();
        StringReader reader = new StringReader(value);
        try {
            prop.load(reader);
        }
        catch (IOException e) {
            throw new KDException(BosErrorCode.bosElasticSearch, key + " configuration resolution error.", (Throwable)e);
        }
        String host = prop.getProperty("host");
        if (StringUtils.isEmpty((String)host)) {
            String ipStr = prop.getProperty("ip");
            if (StringUtils.isEmpty((String)ipStr)) {
                throw new KDException(BosErrorCode.bosElasticSearch, new Object[]{key + " configuration error: ip or host can't be all empty."});
            }
            result.put("ip", ipStr.trim().toLowerCase());
            String httpPortStr = prop.getProperty("httpport");
            if (StringUtils.isEmpty((String)httpPortStr)) {
                httpPortStr = prop.getProperty("port");
                if (StringUtils.isEmpty((String)httpPortStr)) {
                    throw new KDException(BosErrorCode.bosElasticSearch, new Object[]{key + " configuration error: port or httpport can't be all empty."});
                }
                result.put("port", httpPortStr.trim());
            } else {
                result.put("httpport", httpPortStr.trim());
            }
            String serverPort = prop.getProperty("port");
            if (StringUtils.isNotEmpty((String)serverPort)) {
                result.put("port", httpPortStr.trim());
            }
            host = ipStr + ":" + httpPortStr;
        }
        result.put("host", host.trim().toLowerCase());
        String username = prop.getProperty("username");
        if (username != null) {
            result.put("username", username);
        }
        if ((password = prop.getProperty("password")) != null) {
            result.put("password", password);
        }
        result.put("schema", prop.getProperty("schema", "http"));
        result.put("certPath", prop.getProperty("certPath"));
        result.put("certPassword", prop.getProperty("certPassword"));
        String enableStr = prop.getProperty("enable", "true");
        result.put("enable", enableStr.trim().toLowerCase());
        String indexStr = prop.getProperty("index", region);
        result.put("index", indexStr.trim().toLowerCase());
        String clusterNameStr = prop.getProperty("clustername", "elasticsearch");
        result.put("clustername", clusterNameStr);
        String totalFieldsStr = prop.getProperty("totalfields", String.valueOf(8000));
        result.put("totalfields", totalFieldsStr);
        String shardsNumberStr = prop.getProperty("shardsnumber", String.valueOf(5));
        result.put("shardsnumber", shardsNumberStr);
        String perlicasNumverStr = prop.getProperty("replicasnumber", String.valueOf(2));
        result.put("replicasnumber", perlicasNumverStr);
        return result;
    }

    public static HttpHost[] createHosts(Map<String, String> configMap) {
        String[] hostArr;
        String host = configMap.get("host");
        ArrayList<HttpHost> hosts = new ArrayList<HttpHost>(3);
        for (String s : hostArr = host.split(",")) {
            String[] ipAndPort = s.split(":");
            hosts.add(new HttpHost(ipAndPort[0], Integer.parseInt(ipAndPort[1]), "http"));
        }
        return hosts.toArray(new HttpHost[hosts.size()]);
    }

    public static Settings getIndexSettings(Map<String, String> configMap) {
        Settings settings = Settings.build();
        if (configMap != null && configMap.size() > 0) {
            String totalFieldsLimit;
            String numberOfShards;
            String numberOfReplicas = configMap.get(ESKeyMapJavaFieldEnum.SETTINGS_NUMBER_OF_REPLICAS.getEsKey());
            if (numberOfReplicas != null && numberOfReplicas.trim().length() > 0) {
                settings.numberOfReplicas(Integer.parseInt(numberOfReplicas));
            }
            if ((numberOfShards = configMap.get(ESKeyMapJavaFieldEnum.SETTINGS_NUMBER_OF_SHARDS.getEsKey())) != null && numberOfShards.trim().length() > 0) {
                settings.numberOfShards(Integer.parseInt(numberOfShards));
            }
            if ((totalFieldsLimit = configMap.get(ESKeyMapJavaFieldEnum.SETTINGS_TOTAL_FIELDS_LIMIT.getEsKey())) != null && totalFieldsLimit.trim().length() > 0) {
                settings.totalFieldsLimit(Integer.parseInt(totalFieldsLimit));
            }
        }
        return settings;
    }

    public static Settings getIndexSettings(String region) {
        Map<String, String> configMap = ESUtil.getServerConfig(region);
        return ESUtil.getIndexSettings(configMap);
    }

    private static int getMaxMatchSize() {
        String sizeStr = System.getProperty("fulltext.maxmatchsize", "100000");
        return Integer.parseInt(sizeStr);
    }
}

