/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.util.DisCardUtil;
import kd.bos.util.jdbcproxy.PreparedStatementProxy;

class AutoCloseConnPrepareStatement
extends PreparedStatementProxy {
    private final DelegateConnection conn;
    private final PreparedStatement delegate;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    AutoCloseConnPrepareStatement(PreparedStatement delegate, DelegateConnection conn) {
        super(delegate);
        this.conn = conn;
        this.delegate = delegate;
    }

    public void close() throws SQLException {
        if (this.closed.compareAndSet(false, true)) {
            this.closeIgnoredException(this.delegate);
            this.closeIgnoredException(this.conn);
        }
    }

    private void closeIgnoredException(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception ignored) {
            DisCardUtil.discard();
        }
    }

    public Connection getConnection() throws SQLException {
        return this.conn;
    }
}

