/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.api.Probe;
import kd.bos.audit.Audit;
import kd.bos.audit.Auditable;
import kd.bos.audit.sql.SqlAuditor;
import kd.bos.bundle.Resources;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.DBType;
import kd.bos.db.DefaultPreparedBatch;
import kd.bos.db.ExceptionWrapper;
import kd.bos.db.FieldInfo;
import kd.bos.db.IndexInfo;
import kd.bos.db.PeekingDataSet;
import kd.bos.db.QueryMeta;
import kd.bos.db.QueryResult;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlLogger;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.extension.DBExtensionsRegister;
import kd.bos.db.extract.ExtractQuery;
import kd.bos.db.meta.MetaFactory;
import kd.bos.db.sharding.DBShardingRuntime;
import kd.bos.db.stat.DBStat;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.db.tx.RWTableInfo;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXImplicitObject;
import kd.bos.exception.KDExceptionKit;
import kd.bos.exception.SecureExceptionUtil;
import kd.bos.ksql.CONSTANT;
import kd.bos.ksql.schema.KSQLSchemaContext;
import kd.bos.ksql.shell.timeout.context.ThreadRouteKeyContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ManagedThreadFeature;
import kd.bos.trace.TraceConfig;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.tracer.TraceSpanImpl;
import kd.bos.trace.tracer.TracerImpl;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.LRUCacheMap;
import kd.bos.util.ThreadLocals;
import kd.bos.util.hint.SQLHintContext;
import kd.bos.util.hint.SQLHintUtils;
import kd.bos.xdb.QueryTimeout;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.XDBLog;
import kd.bos.xdb.exception.ExceptionUtil;
import kd.bos.xdb.sharding.config.ShardingConfig;
import kd.bos.xdb.tablemanager.TableName;
import kd.bos.xdb.tablemanager.meta.Column;

abstract class BaseDB {
    protected static final Log log = LogFactory.getLog((String)"DB");
    protected static final String tracer_con = "con";
    protected static final String tracer_getconnection = "getconnection";
    protected static final String tracer_result_handle = "result_handle";
    private static final String SQL_HINT_TEMPLATE = "/*+%s*/";
    private static final String DIALECT_PREFIX = "/*dialect*/";
    private static final int DIALECT_PREFIX_LENGTH = "/*dialect*/".length();
    private static final String SQL_WITH_ALGO_KEY = "db.sql.withAlgoKey";
    private static final String audit_sql_table_count = "sql,sql_table_count";
    private static final ThreadLocal<AtomicBoolean> thAccessible = ThreadLocals.create(() -> new AtomicBoolean(true));
    private static final ThreadLocal<AtomicBoolean> thQueryAlone = ThreadLocals.create(() -> new AtomicBoolean(false));
    protected static SqlLogger sqlLogger;
    protected String dbLogTag = "";
    protected static final int fetch_size = 5000;
    protected static final String query_timeout_seconds = "db.query.timeout";
    protected int queryTimeoutSeconds = 300;
    protected boolean enableOutSQL = false;
    protected boolean errorLogWithConnection = false;
    private boolean logWithSql = true;
    private boolean logWithParameter = false;
    private boolean throwWithConnectionLifeCycle = false;
    private boolean sqlLogError = true;
    private boolean checkRollbackedWrite = false;
    private boolean getDMJDBCDataTypes = false;
    private int batchExecuteSplitSize = 5000;
    private ExceptionWrapper.ShowExceptionMode showExceptionMode = ExceptionWrapper.ShowExceptionMode.STRICT;
    private static final Map<String, DBConfig> dbConfigCache;
    private static final Map<DBType, Map<String, Integer>> allDataTypeMap;
    private static final DateTimeFormatter dateTimeFormatter;

    BaseDB() {
    }

    protected void init() {
        ConfigurationUtil.observeBoolean((String)"db.dm.getJDBCDataTypes", (boolean)this.getDMJDBCDataTypes, v -> {
            this.getDMJDBCDataTypes = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.checkRollbackedWrite", (boolean)this.checkRollbackedWrite, v -> {
            this.checkRollbackedWrite = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.sql.out", (boolean)this.enableOutSQL, v -> {
            this.enableOutSQL = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.sql.logError", (boolean)this.sqlLogError, v -> {
            this.sqlLogError = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.sql.out.withSql", (boolean)this.logWithSql, v -> {
            this.logWithSql = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.sql.out.withParameter", (boolean)this.logWithParameter, v -> {
            this.logWithParameter = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.error.log.withconnection", (boolean)this.errorLogWithConnection, v -> {
            this.errorLogWithConnection = v;
        });
        ConfigurationUtil.observeBoolean((String)"db.error.throw.withConnectionLifeCycle", (boolean)this.throwWithConnectionLifeCycle, v -> {
            this.throwWithConnectionLifeCycle = v;
        });
        ConfigurationUtil.observeInteger((String)"db.batchExecuteSplitSize", (int)this.batchExecuteSplitSize, v -> {
            if (v > 10000) {
                v = 10000;
                log.warn("db.batchExecuteSplitSize value is greater than 10000, will be reset to 10000.");
            }
            if (v < 500) {
                v = 500;
                log.warn("db.batchExecuteSplitSize value is less than 500, will be reset to 500.");
            }
            this.batchExecuteSplitSize = v;
        });
        ConfigurationUtil.observeString((String)"db.error.throw.showExceptionMode", (String)"debug", v -> {
            this.showExceptionMode = v == null ? ExceptionWrapper.ShowExceptionMode.STRICT : ("safe".equalsIgnoreCase(v.trim()) ? ExceptionWrapper.ShowExceptionMode.SAFE : ("strict".equalsIgnoreCase(v.trim()) ? ExceptionWrapper.ShowExceptionMode.STRICT : ("debug".equalsIgnoreCase(v.trim()) ? ExceptionWrapper.ShowExceptionMode.DEBUG : ExceptionWrapper.ShowExceptionMode.DEBUG)));
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> T queryAlone(Callable<T> query) {
        try {
            if (thQueryAlone.get().get()) {
                return query.call();
            }
            try {
                thQueryAlone.get().set(true);
                T t = query.call();
                return t;
            }
            finally {
                thQueryAlone.get().set(false);
            }
        }
        catch (Throwable e) {
            throw ExceptionUtil.asRuntimeException((Throwable)e);
        }
    }

    abstract QueryTimeout timeout(int var1);

    final <T> QueryResult<T> query(DBRoute dbRoute, DelegateConnection con, boolean close, String sql, ResultSetHandler<T> rsh, boolean convertResultSet, Object ... params) {
        try (ThreadRouteKeyContext context = ThreadRouteKeyContext.create((String)dbRoute.getRouteKey());){
            if (con.getDBConfig().isReadOnly()) {
                try (SQLHintContext dbReadOnlyHint = SQLHintContext.createDBReadOnlyHint();){
                    QueryResult<T> queryResult = this.queryImpl(dbRoute, con, close, sql, rsh, convertResultSet, params);
                    return queryResult;
                }
            }
            QueryResult<T> queryResult = this.queryImpl(dbRoute, con, close, sql, rsh, convertResultSet, params);
            return queryResult;
        }
    }

    abstract <T> QueryResult<T> queryImpl(DBRoute var1, DelegateConnection var2, boolean var3, String var4, ResultSetHandler<T> var5, boolean var6, Object ... var7);

    abstract int update(DBRoute var1, String var2, Object[] var3, TraceSpan var4);

    abstract int update(DBRoute var1, DelegateConnection var2, boolean var3, String var4, Object ... var5);

    abstract boolean execute(DBRoute var1, String var2, Object[] var3, TraceSpan var4);

    abstract int[] executeBatch(DBRoute var1, String var2, List<Object[]> var3, TraceSpan var4);

    abstract DefaultPreparedBatch prepareBatch(DBRoute var1, String var2, TraceSpan var3, Auditable var4);

    abstract PreparedStatement preparedStatement(DBRoute var1, String var2, TraceSpan var3, Auditable var4);

    abstract <T> T callWithExtContext(DBRoute var1, boolean var2, Callable<T> var3) throws Exception;

    abstract List<ExtractQuery> extractQuery(DBRoute var1, String var2, Object[] var3, TraceSpan var4) throws SQLException;

    boolean exitsTable(DBRoute dbRoute, String tableName, TraceSpan ts) {
        if (tableName == null || tableName.length() == 0) {
            return false;
        }
        if (this.getDBType(dbRoute) == DBType.TiDB) {
            tableName = tableName.toUpperCase(Locale.ENGLISH);
        }
        String oriTableName = this.getOriginalsnapTableNameIfShardingTable(tableName);
        String protoTableName = this.getProtoTableNameIfShardingTable(tableName);
        String oriTableSql = "SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME='" + oriTableName + '\'';
        String protoTableSql = "SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME='" + protoTableName + '\'';
        return this.query(dbRoute, oriTableSql, null, rs -> rs.next(), ts) != false || this.query(dbRoute, protoTableSql, null, rs -> rs.next(), ts) != false;
    }

    List<String> getTables(DBRoute dbRoute, TraceSpan ts) {
        String sql = "show tables";
        return this.query(dbRoute, sql, null, rs -> {
            LinkedList<String> result = new LinkedList<String>();
            while (rs.next()) {
                String tableNameLowerCase;
                String tableName = rs.getString(1);
                if (tableName == null || (tableNameLowerCase = tableName.toLowerCase()).startsWith("temp_") || tableNameLowerCase.startsWith("tmp_")) continue;
                result.add(tableName);
            }
            return new ArrayList(result);
        }, ts);
    }

    boolean exitsTableForManger(DBRoute dbRoute, String tableName, TraceSpan ts) {
        if (tableName == null || tableName.length() == 0) {
            return false;
        }
        String sql = "SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME='" + tableName + '\'';
        return this.query(dbRoute, sql, null, rs -> rs.next(), ts);
    }

    boolean existsIndex(DBRoute dbRoute, String tableName, String indexName, TraceSpan ts) {
        if (tableName == null || tableName.length() == 0) {
            return false;
        }
        tableName = this.getOriginalsnapTableNameIfShardingTable(tableName);
        String sql = "SELECT 1 FROM KSQL_INDEXES  WHERE KSQL_TABNAME='" + tableName + "' and KSQL_INDNAME='" + indexName + '\'';
        return this.query(dbRoute, sql, null, rs -> rs.next(), ts);
    }

    boolean isUseTheSameDatabase(String ... dbRoutes) {
        if (dbRoutes == null || dbRoutes.length < 2) {
            return true;
        }
        HashSet<String> ids = new HashSet<String>();
        for (String dbRoute : dbRoutes) {
            try (DelegateConnection con = (DelegateConnection)TX.__getConnectionSkipWriteArchiveCheck(dbRoute, false);){
                ids.add(con.getDBConfig().getSharingId());
            }
            catch (SQLException e) {
                throw SecureExceptionUtil.wrapSQLException((SQLException)e);
            }
        }
        return ids.size() < 2;
    }

    <T> T query(DBRoute dbRoute, String sql, Object[] params, ResultSetHandler<T> rh, TraceSpan ts) {
        QueryResult<T> ret = this.query(dbRoute, this.getConnection(dbRoute, sql, ts), true, sql, rh, true, params);
        if (ret.getResource() != null) {
            ret.getResource().closeWithConnection();
        }
        return ret.getResult();
    }

    DataSet queryDataSet(String algoKey, DBRoute dbRoute, String sql, Object[] params, QueryMeta queryMeta, TraceSpan ts) {
        DelegateConnection con = this.getConnection(dbRoute, sql, ts);
        sql = this.getSqlWithAlgoKey(algoKey, sql);
        final QueryResult<DataSet> ret = this.query(dbRoute, con, false, sql, rs -> {
            QueryMeta qm = QueryMeta.createOrFixQueryMeta(queryMeta, rs, con.getDBConfig().getDBType());
            rs = qm.convertResultSet(rs);
            return Algo.create((String)algoKey).createDataSet(rs, qm.getRowMeta());
        }, false, params);
        DataSet ds = ret.getResult();
        ds.addListener(new DataSet.Listener(){

            public void afterClosed() {
                if (ret.getResource() != null) {
                    ret.getResource().closeWithConnection();
                }
            }
        });
        return ds;
    }

    PeekingDataSet queryPeekingDataSet(String algoKey, DBRoute dbRoute, String sql, Object[] params, int fetchSize, QueryMeta queryMeta, TraceSpan ts) {
        DelegateConnection con = this.getConnection(dbRoute, sql, ts);
        final QueryResult<PeekingDataSet> ret = this.query(dbRoute, con, false, sql = this.getSqlWithAlgoKey(algoKey, sql), rs -> {
            QueryMeta qm = QueryMeta.createOrFixQueryMeta(queryMeta, rs, con.getDBConfig().getDBType());
            rs = qm.convertResultSet(rs);
            return new PeekingDataSet(algoKey, rs, qm.getRowMeta(), fetchSize);
        }, false, params);
        PeekingDataSet ds = ret.getResult();
        if (ds.getRemaining() != null) {
            ds.getRemaining().addListener(new DataSet.Listener(){

                public void afterClosed() {
                    if (ret.getResource() != null) {
                        ret.getResource().closeWithConnection();
                    }
                }
            });
        } else if (ret.getResource() != null) {
            ret.getResource().closeWithConnection();
        }
        return ds;
    }

    private String getSqlWithAlgoKey(String algoKey, String sql) {
        if (!Boolean.getBoolean(SQL_WITH_ALGO_KEY)) {
            return sql;
        }
        if (null == algoKey || "".equals(algoKey.trim())) {
            log.warn("AlgoKey is null or empty.", new Throwable("AlgoKey_Empty_Stack"));
            return sql;
        }
        if (algoKey.length() > 128) {
            log.warn("AlgoKey is too long:{} .", (Object)algoKey);
            return sql;
        }
        algoKey = this.algoKeyFilter(algoKey);
        boolean isDialect = false;
        if ((sql = sql.trim()).startsWith(DIALECT_PREFIX)) {
            isDialect = true;
            sql = sql.substring(DIALECT_PREFIX_LENGTH);
            while (sql.startsWith(DIALECT_PREFIX)) {
                sql = sql.substring(DIALECT_PREFIX_LENGTH);
            }
        }
        if (isDialect) {
            return DIALECT_PREFIX + String.format(SQL_HINT_TEMPLATE, algoKey) + sql;
        }
        return String.format(SQL_HINT_TEMPLATE, algoKey) + sql;
    }

    private String algoKeyFilter(String algoKey) {
        byte[] bytes = algoKey.getBytes();
        byte[] result = new byte[bytes.length];
        int length = 0;
        for (byte b : bytes) {
            boolean allow = b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57;
            allow |= b == 95;
            allow |= b == 46;
            if (!(allow |= b == 36)) continue;
            result[length] = b;
            ++length;
        }
        return new String(Arrays.copyOf(result, length));
    }

    void setAccessible(boolean accessible) {
        AtomicBoolean b = thAccessible.get();
        b.set(accessible);
    }

    void checkAccessible(String sql) {
        if (!thAccessible.get().get()) {
            throw new IllegalArgumentException(Resources.get((String)"bos-dbengine", (String)"AbstractDBImpl_0", (String)"[%1$s]\u7ebf\u7a0b, DB\u5df2\u88ab\u8bbe\u7f6e\u4e3a\u4e0d\u53ef\u4f7f\u7528: %2$s", (Object[])new Object[]{Thread.currentThread(), sql}));
        }
    }

    void setSqlOut(boolean sqlOut) {
        System.setProperty("db.sql.out", String.valueOf(sqlOut));
        this.enableOutSQL = sqlOut;
    }

    boolean isSqlOut() {
        return this.enableOutSQL;
    }

    boolean isErrorLogWithConnection() {
        return this.errorLogWithConnection;
    }

    public boolean isThrowWithConnectionLifeCycle() {
        return this.throwWithConnectionLifeCycle;
    }

    static void setSqlLogger(SqlLogger sqlLogger) {
        BaseDB.sqlLogger = sqlLogger;
        XDBLog.setSqlLogger((kd.bos.xdb.log.SqlLogger)sqlLogger);
    }

    protected DelegateConnection getConnection(DBRoute dbRoute, String sql, TraceSpan ts) {
        Throwable throwable = null;
        try (TraceSpan tts = Tracer.create((String)"DB", (String)tracer_getconnection);){
            this.checkThreadContext(sql);
            Probe.touch((String)"db");
            DBStat dbStat = DBStat.get();
            if (dbStat != null) {
                dbStat.getSQLList().add(sql);
            }
            try {
                if (dbRoute == null) {
                    throw new IllegalArgumentException(Resources.get((String)"bos-dbengine", (String)"AbstractDBImpl_1", (String)"dbRoute\u4e0d\u80fd\u4e3anull, sql=", (Object[])new Object[0]) + sql);
                }
                RWTableInfo si = RWTableInfo.parseRWTableInfo(sql);
                String routeKey = dbRoute.hasEmptyTableRouteKey() ? dbRoute.getRouteKey() : (si.getMainTable() != null ? dbRoute.getTableRouteKey(si.getMainTable()) : dbRoute.getRouteKey());
                DBShardingRuntime dbShardingRuntime = DBShardingRuntime.get();
                String[] tableNames = si.getAllTables().toArray(new String[si.getAllTables().size()]);
                if (Audit.isEnable() && Audit.isEnable((String)audit_sql_table_count)) {
                    Audit.auditDirect((String)audit_sql_table_count, (int)tableNames.length, (long)0L, (long)0L, (Object[])new Object[]{sql});
                }
                DelegateConnection con = thQueryAlone.get().get() ? (DelegateConnection)TX.__getAloneConnection(routeKey, !si.isWritedSQL(), si.getMainTable(), tableNames) : (DelegateConnection)TX.__getConnection(routeKey, !si.isWritedSQL(), si.getMainTable(), tableNames);
                TXImplicitObject.initConnectSetImplicitOutOfTX(con);
                if (si.isWritedSQL()) {
                    dbShardingRuntime.waitForWriteable(tableNames);
                    con.addWrited(sql);
                    if (TX.inTX()) {
                        if (this.checkRollbackedWrite && TX.__getTXContext().isRollback()) {
                            throw new IllegalStateException("Current transaction has been marked as rollback-only, can not continue to execute writable sql: " + sql);
                        }
                        try {
                            TX.__checkMultiDBWrited();
                        }
                        catch (Exception e) {
                            String msg = "Can not write to multiple databases within the same transaction, sql: " + sql;
                            throw new RuntimeException(msg, e);
                        }
                        TX.__getTransRootTXHandle().__beginOfWrittedDuration();
                    }
                } else {
                    dbShardingRuntime.waitForReadable(tableNames);
                }
                if (CONSTANT.CONNECTION_SHARD) {
                    this.setKSQLSchemaContext(routeKey, con, sql);
                }
                this.traceConnection(con, si.isWritedSQL(), tts);
                DelegateConnection delegateConnection = con;
                return delegateConnection;
            }
            catch (Exception e) {
                try {
                    throw KDExceptionKit.wrapRuntimeException((Throwable)e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    private void traceConnection(DelegateConnection con, boolean writedSQL, TraceSpan tts) {
        if (Tracer.isTracing() && TraceConfig.isTypeEnable((String)"DB") && TraceConfig.isTagEnable((String)"DB", (String)tracer_con)) {
            String url;
            try {
                url = con.getSimpleURL();
            }
            catch (SQLException e) {
                url = e.getMessage();
            }
            String tagValue = "inTX=" + con.inTX() + ", propagation=" + (Object)((Object)con.getTXPropagation()) + ", sql_rw=" + (writedSQL ? "w" : "r") + ", con_rw=" + (con.currentIsUseForReadOnly() ? "r" : "rw") + ", url=" + url;
            tts.addTag(tracer_con, tagValue);
        }
    }

    private void setKSQLSchemaContext(String routeKey, DelegateConnection connection, String sql) throws SQLException {
        RequestContextInfo contextInfo = RequestContextInfo.get();
        DBConfig dbConfig = this.getDBConfig(contextInfo, routeKey);
        if (dbConfig != null) {
            DBType dbType = dbConfig.getDBType();
            if (dbType == DBType.MySQL || dbType == DBType.PostgreSQL || dbType == DBType.TDSQL || dbType == DBType.TiDB) {
                String schema;
                String string = schema = dbType == DBType.MySQL || dbType == DBType.TDSQL || dbType == DBType.TiDB ? dbConfig.getSchema() : dbConfig.getMode();
                if (sql.trim().startsWith(DIALECT_PREFIX)) {
                    String changeSql = dbType == DBType.MySQL || dbType == DBType.TDSQL || dbType == DBType.TiDB ? "use " : "set search_path to ";
                    connection.setCurrentSchema(schema);
                    try (Statement statement = connection.createStatement();){
                        statement.execute(DIALECT_PREFIX + changeSql + schema);
                    }
                }
                KSQLSchemaContext schemaContext = KSQLSchemaContext.getOrCreate();
                schemaContext.setRouteKey(routeKey);
                schemaContext.setSchema(schema);
                schemaContext.setChangeSchema(true);
                connection.setCurrentSchema(schema);
            } else {
                KSQLSchemaContext.clear();
            }
        }
    }

    private DBConfig getDBConfig(RequestContextInfo contextInfo, String routeKey) {
        String tenantId = contextInfo.getTenantId();
        String accountId = contextInfo.getAccountId();
        String key = tenantId + "#" + accountId + "#" + routeKey;
        DBConfig config = dbConfigCache.get(key);
        if (config == null) {
            List<DBConfig> configs = DBExtensionsRegister.getDBConfigs(tenantId, routeKey, accountId, true);
            if (configs.isEmpty()) {
                return null;
            }
            config = configs.get(0);
            dbConfigCache.put(key, config);
        }
        return config;
    }

    private void checkThreadContext(String sql) {
        this.checkAccessible(sql);
        String str = System.getProperty("bos.checkThreadContext");
        if ((str == null || "true".equals(str)) && !ManagedThreadFeature.isManaged()) {
            String msg = "[" + Thread.currentThread() + "] Please use the thread pool utils (kd.bos.threads.ThreadPools) to create thread to access the database, sql: " + sql;
            if (ManagedThreadFeature.isTraceManagedThreadFeatureEnabled()) {
                msg = msg + "\n" + ManagedThreadFeature.getAndRemoveManagedThreadTrace();
            }
            throw new RuntimeException(msg);
        }
    }

    protected Throwable rethrow(DelegateConnection conn, Throwable cause, String sql, Object ... params) {
        ExceptionWrapper.Builder builder = ExceptionWrapper.newBuilder();
        builder.setCause(cause).setConn(conn).setSql(sql).setParams(params).setErrorLogWithConnection(this.errorLogWithConnection).setThrowWithConnectionLifeCycle(this.throwWithConnectionLifeCycle).setLogWithSql(this.logWithSql).setLogWithParameter(this.logWithParameter).setShowExceptionMode(this.showExceptionMode);
        ExceptionWrapper wrapper = builder.build();
        if (this.sqlLogError) {
            log.error(wrapper.getLogCause());
        }
        return wrapper.getRethrowCause();
    }

    protected void close(DelegateConnection conn, boolean shouldRollback) {
        if (conn != null) {
            try {
                conn.close(shouldRollback);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void close(ResultSet rs) {
        try {
            if (rs != null && !rs.isClosed()) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void close(Statement stmt) {
        try {
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void audit(String sql) {
        SqlAuditor.auditAll((String)sql);
    }

    private String toParameterString(Object[] params) {
        if (params == null || params.length == 0) {
            return "";
        }
        int len = Math.min(200, params.length);
        StringBuilder s = new StringBuilder(len * 8);
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                s.append(',');
            }
            if (params[i] instanceof String) {
                s.append('\'').append(params[i]).append('\'');
                continue;
            }
            s.append(params[i]);
        }
        if (len < params.length) {
            s.append("...(").append(params.length).append(')');
        }
        return s.toString();
    }

    protected void logSQLCost(DBRoute dbRoute, DelegateConnection con, String sql, Object[] params, long ts) {
        this.logSQLCost(dbRoute, con, sql, this.logWithParameter ? Collections.singletonList(params) : null, ts);
    }

    protected void logSQLCost(DBRoute dbRoute, DelegateConnection con, String sql, List<Object[]> paramsList, long ts) {
        if (sqlLogger != null || log.isInfoEnabled()) {
            long ms = System.currentTimeMillis() - ts;
            boolean readonly = con.getDBConfig().isReadOnly();
            StringBuilder msg = new StringBuilder(this.dbLogTag).append("----sql@").append(dbRoute.getRouteKey()).append("->").append(con.getRouteKey()).append("#con").append(con.id());
            if (readonly) {
                msg.append("(readonly)");
            }
            msg.append("----\r\n");
            TraceSpan traceSpan = TracerImpl.getCurrent();
            if (traceSpan instanceof TraceSpanImpl) {
                try {
                    this.appendCostDetail(ms, msg, (TraceSpanImpl)traceSpan);
                }
                catch (Exception e) {
                    log.error("DB append cost detail error:" + e.getMessage(), (Throwable)e);
                }
            }
            msg.append(SQLHintUtils.getSQLHints()).append(sql);
            if (this.logWithParameter && paramsList != null && paramsList.size() > 0) {
                int i = 0;
                for (Object[] params : paramsList) {
                    if (params != null && params.length > 0) {
                        msg.append("\r\n").append(this.toParameterString(params));
                    }
                    if (++i != 20) continue;
                    msg.append("\r\n...(").append(paramsList.size()).append(')');
                    break;
                }
            }
            msg.append("\r\n");
            if (sqlLogger != null) {
                sqlLogger.logMessage(msg.toString());
            } else {
                log.info(msg.toString());
            }
        }
    }

    private void appendCostDetail(long ms, StringBuilder msg, TraceSpanImpl traceSpan) {
        msg.append("#cost:").append(traceSpan.getCost()).append("ms,time is:").append(dateTimeFormatter.format(LocalDateTime.now())).append(",");
        LRUCacheMap treeCostMap = traceSpan.getTreeCostMap();
        if (!treeCostMap.isEmpty()) {
            msg.append(" include(");
            this.appendMethodCost(msg, (LRUCacheMap<String, Integer>)((LRUCacheMap)treeCostMap.get((Object)traceSpan.getType())));
            treeCostMap.remove((Object)traceSpan.getType());
            treeCostMap.forEach((k, v) -> {
                msg.append(", ");
                this.appendMethodCost(msg, (LRUCacheMap<String, Integer>)v);
            });
            msg.append(" ...)");
        }
        msg.append("\r\n");
    }

    private void appendMethodCost(StringBuilder msg, LRUCacheMap<String, Integer> nameCostMap) {
        if (nameCostMap != null && !nameCostMap.isEmpty()) {
            AtomicInteger n = new AtomicInteger();
            nameCostMap.forEach((k, v) -> {
                if (n.getAndIncrement() > 0) {
                    msg.append(", ");
                }
                msg.append((String)k).append(':').append(v).append("ms");
            });
        }
    }

    protected List<FieldInfo> getFieldInfo(DBRoute dbRoute, String tableName, TraceSpan ts) {
        if (tableName == null || tableName.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<FieldInfo> ret = new ArrayList<FieldInfo>(16);
        tableName = this.getOriginalsnapTableNameIfShardingTable(tableName);
        List<Column> columns = MetaFactory.getMeta(DB.getDBType(dbRoute)).queryColumns(dbRoute, tableName);
        Map<String, Integer> jdbcDataTypes = this.getJDBCDataTypes(dbRoute);
        for (Column column : columns) {
            FieldInfo fieldInfo = new FieldInfo();
            fieldInfo.setFieldName(column.getColumnName());
            fieldInfo.setDataType(column.getDataType());
            fieldInfo.setFieldId(column.getColumnId());
            fieldInfo.setDataLength(column.getDataLength());
            fieldInfo.setDataPrecision(column.getDataPrecision());
            fieldInfo.setDataScale(column.getDataScale());
            fieldInfo.setDataDefault(column.getDataDefault());
            fieldInfo.setNullable(column.isNullable());
            fieldInfo.setFieldComment(column.getColumnComment());
            if (jdbcDataTypes.containsKey(fieldInfo.getDataType().toUpperCase(Locale.ENGLISH))) {
                fieldInfo.setJDBCDataType(jdbcDataTypes.get(fieldInfo.getDataType().toUpperCase(Locale.ENGLISH)));
            }
            ret.add(fieldInfo);
        }
        return ret;
    }

    private String getFieldInfoQuerySql(DBType dbType, String tableName) {
        if (DBType.Oracle == dbType || DBType.DM == dbType || DBType.OceanBase_Oracle == dbType) {
            return "/*dialect*/SELECT COLUMN_NAME, DATA_TYPE FROM USER_TAB_COLUMNS WHERE TABLE_NAME = '" + tableName.toUpperCase() + '\'';
        }
        if (DBType.MySQL == dbType || DBType.TDSQL == dbType || DBType.TiDB == dbType) {
            return "/*dialect*/SELECT column_name,data_type FROM information_schema.COLUMNS WHERE table_name = '" + tableName + "' AND table_schema = SCHEMA ()";
        }
        if (DBType.PostgreSQL == dbType || DBType.GaussDB == dbType || DBType.KingBase == dbType || DBType.Vastbase == dbType || DBType.Gbase == dbType || DBType.Gauss200 == dbType || DBType.Greenplum == dbType) {
            return "/*dialect*/SELECT column_name,data_type FROM information_schema.columns WHERE table_name = '" + tableName.toLowerCase() + '\'';
        }
        if (DBType.SQLServer == dbType) {
            return "/*dialect*/select B.name as column_name, T.name as data_type from sys.tables A inner join sys.columns B ON B.object_id = A.object_id INNER JOIN sys.types T on B.user_type_id = T.user_type_id LEFT JOIN sys.extended_properties C ON C.major_id = B.object_id AND C.minor_id = B.column_id LEFT JOIN sys.syscomments D ON D.id = B.default_object_id WHERE A.name = '" + tableName.toUpperCase() + "'";
        }
        if (DBType.YasDB == dbType) {
            return "/*dialect*/SELECT COLUMN_NAME, DATA_TYPE FROM USER_TAB_COLUMNS WHERE TABLE_NAME = '" + tableName.toUpperCase() + '\'';
        }
        if (DBType.HANA == dbType) {
            return String.format("/*dialect*/SELECT COLUMN_NAME, DATA_TYPE_NAME FROM SYS.TABLE_COLUMNS WHERE SCHEMA_NAME = CURRENT_SCHEMA AND TABLE_NAME='%s'", tableName.toUpperCase(Locale.ENGLISH));
        }
        throw new RuntimeException("dbType " + dbType.name() + " not supported yet!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<IndexInfo> getIndexInfo(DBRoute dbRoute, String tableName, TraceSpan ts) {
        if (tableName == null) return Collections.emptyList();
        if (tableName.length() == 0) {
            return Collections.emptyList();
        }
        tableName = this.getOriginalsnapTableNameIfShardingTable(tableName);
        try (DataSet ds = this.queryDataSet("getIndexInfo", dbRoute, this.getIndexInfoQuerySql(this.getDBType(dbRoute), tableName), null, null, ts);){
            HashMap<String, IndexInfo> retMap = new HashMap<String, IndexInfo>(8);
            while (ds.hasNext()) {
                Row row = ds.next();
                String indexName = row.getString(0);
                String fieldName = row.getString(1);
                String sortType = row.getString(2);
                String descColumnName = row.getString(3);
                IndexInfo existIndexInfo = (IndexInfo)retMap.get(indexName);
                if (descColumnName != null && "DESC".equals(sortType)) {
                    fieldName = descColumnName.replace("\"", "");
                }
                if (existIndexInfo != null) {
                    existIndexInfo.addIndexFieldInfo(new IndexInfo.IndexFieldInfo(fieldName, sortType));
                    continue;
                }
                ArrayList<IndexInfo.IndexFieldInfo> indexFieldInfo = new ArrayList<IndexInfo.IndexFieldInfo>(8);
                indexFieldInfo.add(new IndexInfo.IndexFieldInfo(fieldName, sortType));
                retMap.put(indexName, new IndexInfo(indexName, indexFieldInfo));
            }
            ArrayList<IndexInfo> arrayList = new ArrayList<IndexInfo>(retMap.values());
            return arrayList;
        }
        catch (Exception e) {
            throw KDExceptionKit.wrapRuntimeException((Throwable)e);
        }
    }

    private String getIndexInfoQuerySql(DBType dbType, String tableName) {
        if (DBType.Oracle == dbType || DBType.DM == dbType || DBType.OceanBase_Oracle == dbType) {
            return "/*dialect*/SELECT uidx.index_name as index_name, uidxc.column_name as column_name, uidxc.descend as sort_type, uie.column_expression as desc_column_name FROM USER_INDEXES uidx LEFT JOIN user_ind_expressions uie ON uie.index_name = uidx.index_name,USER_IND_COLUMNS uidxc WHERE uidx.table_name=uidxc.table_name AND uidx.index_name = uidxc.index_name AND uidx.table_name= '" + tableName.toUpperCase() + "' ORDER BY uidx.uniqueness DESC";
        }
        if (DBType.MySQL == dbType || DBType.TDSQL == dbType || DBType.TiDB == dbType) {
            return "/*dialect*/SELECT INDEX_NAME, COLUMN_NAME, if(`COLLATION`='A','ASC','DESC') SORT_TYPE, null as PLACE_HOLDER FROM INFORMATION_SCHEMA.STATISTICS WHERE TABLE_SCHEMA = SCHEMA() AND (TABLE_NAME = '" + tableName + "')";
        }
        if (DBType.PostgreSQL == dbType || DBType.GaussDB == dbType || DBType.KingBase == dbType || DBType.Vastbase == dbType || DBType.Gbase == dbType || DBType.Gauss200 == dbType || DBType.Greenplum == dbType) {
            return "/*dialect*/SELECT c2.relname AS index_name, pg_get_indexdef (c2.oid,(i.keys ).n, FALSE) AS COLUMN_NAME, CASE i.indoption [ (i.keys ).n - 1 ] & 1 WHEN 1 THEN 'DESC' ELSE 'ASC' END AS sort_type, NULL AS place_holder FROM pg_class c1 JOIN ( SELECT i.indexrelid, i.indrelid, i.indoption, information_schema._pg_expandarray (i.indkey) AS keys FROM pg_index i ) i ON (c1.oid = i.indrelid) JOIN pg_class c2 ON (c2.oid = i.indexrelid) JOIN pg_am am ON (c2.relam = am.oid) WHERE c1.relname = '" + tableName.toLowerCase() + '\'';
        }
        if (DBType.YasDB == dbType) {
            return "/*dialect*/SELECT uidx.index_name as index_name, uidxc.column_name as column_name, uidxc.descend as sort_type, uie.column_expression as desc_column_name FROM USER_INDEXES uidx LEFT JOIN USER_ind_expressions uie ON uie.index_name = uidx.index_name,USER_IND_COLUMNS uidxc WHERE uidx.table_name=uidxc.table_name AND uidx.index_name = uidxc.index_name AND uidx.table_name= '" + tableName.toUpperCase() + "' ORDER BY uidx.uniqueness DESC";
        }
        if (DBType.HANA == dbType) {
            return String.format("/*dialect*/SELECT TABLE_NAME ,INDEX_NAME, COLUMN_NAME, CASE WHEN ASCENDING_ORDER='TRUE' THEN 'ASC' ELSE 'DESC' END, NULL AS PLACE_HOLD  FROM SYS.INDEX_COLUMNS WHERE SCHEMA_NAME = CURRENT_SCHEMA AND TABLE_NAME = '%s' AND CONSTRAINT IS NULL", tableName.toUpperCase(Locale.ENGLISH));
        }
        throw new RuntimeException("dbType " + dbType.name() + " not supported yet!");
    }

    @Deprecated
    String getProtoTableNameIfShardingTable(String tableName) {
        ShardingConfig config;
        if (DB.isXDBEnable() && (config = XDBConfig.getShardingConfigProvider().getConfig(tableName)) != null && config.isEnabled()) {
            return TableName.of((String)tableName).getPrototypeTable();
        }
        return tableName;
    }

    String getOriginalsnapTableNameIfShardingTable(String tableName) {
        ShardingConfig config;
        if (DB.isXDBEnable() && (config = XDBConfig.getShardingConfigProvider().getConfig(tableName)) != null && config.isEnabled()) {
            return TableName.of((String)tableName).getOriginalsnapTable();
        }
        return tableName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DBType getDBType(DBRoute dbRoute) {
        try (Connection con = TX.__getConnectionSkipWriteArchiveCheck(dbRoute.getRouteKey(), false);){
            kd.bos.xdb.datasource.DBType dbType = ((DelegateConnection)con).getDBType();
            switch (dbType) {
                case dm: {
                    DBType dBType = DBType.DM;
                    return dBType;
                }
                case gs: {
                    DBType dBType = DBType.GS;
                    return dBType;
                }
                case gs100: {
                    DBType dBType = DBType.GS100;
                    return dBType;
                }
                case mysql: {
                    DBType dBType = DBType.MySQL;
                    return dBType;
                }
                case oracle: {
                    DBType dBType = DBType.Oracle;
                    return dBType;
                }
                case postgresql: {
                    DBType dBType = DBType.PostgreSQL;
                    return dBType;
                }
                case sqlserver: {
                    DBType dBType = DBType.SQLServer;
                    return dBType;
                }
                case gaussdb: {
                    DBType dBType = DBType.GaussDB;
                    return dBType;
                }
                case kingbase: {
                    DBType dBType = DBType.KingBase;
                    return dBType;
                }
                case vastbase: {
                    DBType dBType = DBType.Vastbase;
                    return dBType;
                }
                case tdsql: {
                    DBType dBType = DBType.TDSQL;
                    return dBType;
                }
                case gbase: {
                    DBType dBType = DBType.Gbase;
                    return dBType;
                }
                case tidb: {
                    DBType dBType = DBType.TiDB;
                    return dBType;
                }
                case yasdb: {
                    DBType dBType = DBType.YasDB;
                    return dBType;
                }
                case oceanbase_oracle: {
                    DBType dBType = DBType.OceanBase_Oracle;
                    return dBType;
                }
                case greenplum: {
                    DBType dBType = DBType.Greenplum;
                    return dBType;
                }
                case clickhouse: {
                    DBType dBType = DBType.ClickHouse;
                    return dBType;
                }
                case hana: {
                    DBType dBType = DBType.HANA;
                    return dBType;
                }
            }
            throw new RuntimeException(Resources.get((String)"bos-dbengine", (String)"DB_0", (String)"\u4e0d\u652f\u6301\u6570\u636e\u5e93\u7c7b\u578b: ", (Object[])new Object[0]) + dbType + "/" + con.getMetaData().getDatabaseProductName().toLowerCase());
        }
        catch (SQLException e) {
            throw SecureExceptionUtil.wrapSQLException((SQLException)e);
        }
    }

    private String getPrimaryKeysQuerySql(DBType dbType, String tableName) {
        if (DBType.Oracle == dbType || DBType.DM == dbType || DBType.OceanBase_Oracle == dbType) {
            return "/*dialect*/select col.column_name from user_constraints con, user_cons_columns col where con.constraint_name = col.constraint_name and con.constraint_type='P' and col.table_name = '" + tableName.toUpperCase() + "' order by position";
        }
        if (DBType.MySQL == dbType || DBType.TDSQL == dbType || DBType.TiDB == dbType) {
            return "/*dialect*/select column_name from information_schema.columns where table_name = '" + tableName + "' and TABLE_SCHEMA = schema() and column_key = 'PRI'";
        }
        if (DBType.PostgreSQL == dbType || DBType.GaussDB == dbType || DBType.KingBase == dbType || DBType.Vastbase == dbType || DBType.Gbase == dbType || DBType.Greenplum == dbType) {
            return "/*dialect*/select kcu.column_name as key_column from information_schema.table_constraints tco join information_schema.key_column_usage kcu on kcu.constraint_name = tco.constraint_name and kcu.constraint_schema = tco.constraint_schema and kcu.constraint_name = tco.constraint_name where tco.constraint_type = 'PRIMARY KEY' and kcu.table_name = '" + tableName.toLowerCase() + "' order by kcu.ordinal_position";
        }
        if (DBType.SQLServer == dbType) {
            return "/*dialect*/select c.name from sysindexes i join sysindexkeys k on i.id = k.id and i.indid = k.indid join sysobjects o on i.id = o.id join syscolumns c on i.id=c.id and k.colid = c.colid where o.xtype = 'U' and exists(select 1 from sysobjects where xtype = 'PK' and name = i.name) and o.name= '" + tableName.toUpperCase() + '\'';
        }
        if (DBType.YasDB == dbType) {
            return "/*dialect*/select col.column_name from user_constraints con, user_cons_columns col where con.constraint_name = col.constraint_name and con.constraint_type='P' and col.table_name = '" + tableName.toUpperCase() + "'";
        }
        if (DBType.HANA == dbType) {
            return String.format("/*dialect*/SELECT COLUMN_NAME FROM SYS.INDEX_COLUMNS WHERE SCHEMA_NAME = CURRENT_SCHEMA AND TABLE_NAME = '%s' AND CONSTRAINT = 'PRIMARY KEY'", tableName.toUpperCase(Locale.ENGLISH));
        }
        if (DBType.ClickHouse == dbType) {
            return String.format("/*dialect*/SELECT primary_key FROM system.tables WHERE  table = '%s'", tableName.toLowerCase(Locale.ENGLISH));
        }
        throw new RuntimeException("dbType " + dbType.name() + " not supported yet!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<String> getPrimaryKeys(DBRoute dbRoute, String tableName, TraceSpan ts) {
        if (tableName == null) return Collections.emptyList();
        if (tableName.length() == 0) {
            return Collections.emptyList();
        }
        tableName = this.getOriginalsnapTableNameIfShardingTable(tableName);
        try (DataSet ds = this.queryDataSet("getPrimaryKeys", dbRoute, this.getPrimaryKeysQuerySql(this.getDBType(dbRoute), tableName), null, null, ts);){
            ArrayList<String> ret = new ArrayList<String>(1);
            while (ds.hasNext()) {
                Row row = ds.next();
                ret.add(row.getString(0));
            }
            ArrayList<String> arrayList = ret;
            return arrayList;
        }
        catch (Exception e) {
            throw KDExceptionKit.wrapRuntimeException((Throwable)e);
        }
    }

    protected List<String> getColumnNames(DBRoute dbRoute, String table, TraceSpan ts) {
        table = this.getOriginalsnapTableNameIfShardingTable(table);
        String sql = "SELECT KSQL_COL_NAME FROM KSQL_USERCOLUMNS WHERE KSQL_TABNAME ='" + table + '\'';
        return this.query(dbRoute, sql, null, new ResultSetHandler<List<String>>(){

            @Override
            public List<String> handle(ResultSet rs) throws Exception {
                ArrayList<String> columnNames = new ArrayList<String>(16);
                while (rs.next()) {
                    columnNames.add(rs.getString(1));
                }
                return columnNames;
            }
        }, ts);
    }

    public boolean columnIsNullable(DBRoute dbRoute, String tableName, String columnName, TraceSpan ts) {
        tableName = this.getOriginalsnapTableNameIfShardingTable(tableName);
        List<Column> columns = MetaFactory.getMeta(DB.getDBType(dbRoute)).queryColumns(dbRoute, tableName);
        List nullableColumns = columns.stream().filter(column -> column.getColumnName().equalsIgnoreCase(columnName) && column.isNullable()).collect(Collectors.toList());
        return !nullableColumns.isEmpty();
    }

    final boolean existColumn(DBRoute dbRoute, String tableName, String columnName, TraceSpan ts) {
        tableName = this.getOriginalsnapTableNameIfShardingTable(tableName);
        List<Column> columns = MetaFactory.getMeta(DB.getDBType(dbRoute)).queryColumns(dbRoute, tableName);
        if (columnName != null && !columns.isEmpty()) {
            return !columns.stream().filter(column -> column.getColumnName() != null && column.getColumnName().equalsIgnoreCase(columnName)).collect(Collectors.toList()).isEmpty();
        }
        return false;
    }

    protected int[] splitExecuteBatch(List<Object[]> paramsList, SplitExecuteBatch execute) throws SQLException {
        if (this.batchExecuteSplitSize <= 0 || paramsList.size() <= this.batchExecuteSplitSize) {
            return execute.apply(paramsList);
        }
        List shardList = Lists.partition(paramsList, (int)this.batchExecuteSplitSize);
        ArrayList<int[]> shardExecuteResult = new ArrayList<int[]>(shardList.size());
        int totalCount = 0;
        for (List param : shardList) {
            int[] r = execute.apply(param);
            totalCount += r.length;
            shardExecuteResult.add(r);
        }
        int[] result = new int[totalCount];
        int pos = 0;
        for (int[] shardResult : shardExecuteResult) {
            System.arraycopy(shardResult, 0, result, pos, shardResult.length);
            pos += shardResult.length;
        }
        return result;
    }

    private Map<String, Integer> getJDBCDataTypes(DBRoute dbRoute) {
        DBType dbType = DB.getDBType(dbRoute);
        if (!this.getDMJDBCDataTypes && dbType == DBType.DM) {
            return new HashMap<String, Integer>(0);
        }
        Map<String, Integer> dataTypeMap = allDataTypeMap.get((Object)dbType);
        if (dataTypeMap != null) {
            return dataTypeMap;
        }
        log.info("========2. in  getJDBCDataTypes");
        dataTypeMap = new HashMap<String, Integer>(16);
        try (Connection connection = TX.__getConnectionSkipWriteArchiveCheck(dbRoute.getRouteKey(), false);
             ResultSet typeInfo = connection.getMetaData().getTypeInfo();){
            log.info("========3. in  getJDBCDataTypes");
            while (typeInfo.next()) {
                String typeName = typeInfo.getString("TYPE_NAME").toUpperCase(Locale.ENGLISH);
                int dataType = typeInfo.getInt("DATA_TYPE");
                dataTypeMap.put(typeName, dataType);
            }
            log.info("========4. in  getJDBCDataTypes");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        log.info("========5. in  getJDBCDataTypes");
        allDataTypeMap.putIfAbsent(dbType, dataTypeMap);
        return dataTypeMap;
    }

    static {
        dbConfigCache = new ConcurrentHashMap<String, DBConfig>();
        allDataTypeMap = new ConcurrentHashMap<DBType, Map<String, Integer>>(1);
        dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    }

    @FunctionalInterface
    protected static interface SplitExecuteBatch {
        public int[] apply(List<Object[]> var1) throws SQLException;
    }
}

