/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.audit.Audit;
import kd.bos.audit.Auditable;
import kd.bos.audit.sql.ForbidHardSQL;
import kd.bos.db.AutoCloseConnPrepareStatement;
import kd.bos.db.BaseDB;
import kd.bos.db.DBRoute;
import kd.bos.db.DefaultPreparedBatch;
import kd.bos.db.ExResultSetHandler;
import kd.bos.db.KSqlTransferImpl;
import kd.bos.db.QueryMeta;
import kd.bos.db.QueryResource;
import kd.bos.db.QueryResult;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SpaceAsEmptyString;
import kd.bos.db.extract.ExtractQuery;
import kd.bos.db.extract.ExtractQueryImpl;
import kd.bos.db.govern.DBTimeoutHandler;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXImplicitObject;
import kd.bos.exception.KDExceptionKit;
import kd.bos.exception.SecureExceptionUtil;
import kd.bos.ksql.shell.timeout.context.ThreadRouteKeyContext;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.DisCardUtil;
import kd.bos.xdb.ParameterSetter;
import kd.bos.xdb.QueryTimeout;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.merge.WrapCloseResultSet;
import kd.bos.xdb.parameter.ParameterFillerFactory;
import kd.bos.xdb.temptable.facade.TemptableFacadeContext;
import kd.bos.xdb.temptable.facade.TemptableFacadeContexts;
import kd.bos.xdb.temptable.manager.TemptableFacadeResolver;
import kd.bos.xdb.temptable.manager.TemptableManager;

public final class DBImpl
extends BaseDB {
    private static final DBImpl self = new DBImpl();
    private static final ThreadLocal<QueryTimeout> thTimeout = new ThreadLocal();

    public static DBImpl getInstance() {
        return self;
    }

    private DBImpl() {
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        SpaceAsEmptyString.setupSpaceAsEmptyStringByConfig();
        ConfigurationUtil.observeInteger((String)"db.query.timeout", (int)300, v -> {
            this.queryTimeoutSeconds = v;
        });
    }

    public ResultSet queryExtracted(DBRoute dbRoute, String sql, Object[] params, TraceSpan ts) {
        DelegateConnection con = this.getConnection(dbRoute, sql, ts);
        QueryResult<ResultSet> ret = this.query(dbRoute, con, false, sql, rs -> rs, true, params);
        try {
            return new WrapCloseResultSet(ret.getResult(), () -> {
                if (ret.getResource() != null) {
                    ret.getResource().close();
                }
            }, false);
        }
        catch (SQLException e) {
            throw SecureExceptionUtil.wrapSQLException((SQLException)e);
        }
    }

    @Override
    int update(DBRoute dbRoute, String sql, Object[] params, TraceSpan ts) {
        return this.update(dbRoute, this.getConnection(dbRoute, sql, ts), true, sql, params);
    }

    @Override
    boolean execute(DBRoute dbRoute, String sql, Object[] params, TraceSpan ts) {
        int[] uc;
        List<Object[]> paramsList;
        if (params != null && params.length > 0) {
            paramsList = new ArrayList(1);
            paramsList.add(params);
        } else {
            paramsList = Collections.emptyList();
        }
        for (int c : uc = this.executeBatch(dbRoute, sql, paramsList, ts)) {
            if (c <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    int[] executeBatch(DBRoute dbRoute, String sql, List<Object[]> paramsList, TraceSpan ts) {
        return this.executeBatch(dbRoute, this.getConnection(dbRoute, sql, ts), true, sql, paramsList);
    }

    @Override
    <T> QueryResult<T> queryImpl(DBRoute dbRoute, DelegateConnection con, boolean close, String sql, ResultSetHandler<T> rsh, boolean convertResultSet, Object ... params) {
        sql = this.handleTemptableFacade(dbRoute.getRouteKey(), sql);
        TXImplicitObject.ImplicitObject implicitObject = con.getCtx().getImplicitObject().handleImplicitTransaction(sql, con);
        boolean rollback = false;
        QueryResource resource = null;
        try {
            Object result;
            ResultSet rs;
            Statement stmt;
            block72: {
                stmt = null;
                rs = null;
                result = null;
                long ts = System.currentTimeMillis();
                try {
                    Object tts;
                    if (sqlLogger != null) {
                        sqlLogger.logSQL(sql, params);
                    }
                    if (Audit.isEnable()) {
                        this.audit(sql);
                    }
                    if (params == null || params.length == 0) {
                        stmt = con.createStatement(1003, 1007);
                        stmt.setQueryTimeout(this.getQueryTimeoutSeconds());
                        stmt.setFetchDirection(1000);
                        stmt.setFetchSize(5000);
                        if (rsh instanceof ExResultSetHandler) {
                            boolean firstIsResultSet = stmt.execute(sql);
                            tts = Tracer.create((String)"DB", (String)"result_handle");
                            Throwable throwable = null;
                            try {
                                result = ((ExResultSetHandler)rsh).handle(firstIsResultSet, stmt, con);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (tts != null) {
                                    if (throwable != null) {
                                        try {
                                            tts.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                    } else {
                                        tts.close();
                                    }
                                }
                            }
                        }
                        stmt.execute(sql);
                        rs = stmt.getResultSet();
                        TraceSpan tts2 = Tracer.create((String)"DB", (String)"result_handle");
                        tts = null;
                        try {
                            if (convertResultSet) {
                                rs = QueryMeta.createOrFixQueryMeta(null, rs, con.getDBConfig().getDBType()).convertResultSet(rs);
                            }
                            result = rsh.handle(rs);
                        }
                        catch (Throwable throwable) {
                            tts = throwable;
                            throw throwable;
                        }
                        finally {
                            if (tts2 != null) {
                                if (tts != null) {
                                    try {
                                        tts2.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)tts).addSuppressed(throwable);
                                    }
                                } else {
                                    tts2.close();
                                }
                            }
                        }
                        if (Audit.isEnable()) {
                            ForbidHardSQL.audit((String)sql);
                        }
                    } else {
                        stmt = con.prepareStatement(sql, 1003, 1007);
                        stmt.setQueryTimeout(this.getQueryTimeoutSeconds());
                        stmt.setFetchDirection(1000);
                        stmt.setFetchSize(5000);
                        this.fillStatement((PreparedStatement)stmt, params, con);
                        if (rsh instanceof ExResultSetHandler) {
                            boolean firstIsResultSet = ((PreparedStatement)stmt).execute();
                            tts = Tracer.create((String)"DB", (String)"result_handle");
                            Throwable throwable = null;
                            try {
                                result = ((ExResultSetHandler)rsh).handle(firstIsResultSet, stmt, con);
                            }
                            catch (Throwable throwable4) {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            finally {
                                if (tts != null) {
                                    if (throwable != null) {
                                        try {
                                            tts.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable.addSuppressed(throwable5);
                                        }
                                    } else {
                                        tts.close();
                                    }
                                }
                            }
                        }
                        ((PreparedStatement)stmt).execute();
                        rs = stmt.getResultSet();
                        TraceSpan tts3 = Tracer.create((String)"DB", (String)"result_handle");
                        tts = null;
                        try {
                            if (convertResultSet) {
                                rs = QueryMeta.createOrFixQueryMeta(null, rs, con.getDBConfig().getDBType()).convertResultSet(rs);
                            }
                            result = rsh.handle(rs);
                        }
                        catch (Throwable throwable) {
                            tts = throwable;
                            throw throwable;
                        }
                        finally {
                            if (tts3 != null) {
                                if (tts != null) {
                                    try {
                                        tts3.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)tts).addSuppressed(throwable);
                                    }
                                } else {
                                    tts3.close();
                                }
                            }
                        }
                    }
                    if (!this.enableOutSQL) break block72;
                }
                catch (Throwable e) {
                    try {
                        rollback = true;
                        this.close(rs);
                        this.close(stmt);
                        throw this.rethrow(con, e, sql, params);
                    }
                    catch (Throwable throwable) {
                        if (this.enableOutSQL) {
                            this.logSQLCost(dbRoute, con, sql, params, ts);
                        }
                        if (close || rollback && !TX.inTX()) {
                            if (implicitObject != null) {
                                implicitObject.release();
                            }
                            this.close(rs);
                            this.close(stmt);
                            this.close(con, rollback);
                        } else {
                            ResultSet frs = rs;
                            Statement fstmt = stmt;
                            resource = new QueryResource(con, sql, () -> {
                                if (implicitObject != null) {
                                    implicitObject.release();
                                }
                                this.close(frs);
                                this.close(fstmt);
                            });
                        }
                        throw throwable;
                    }
                }
                this.logSQLCost(dbRoute, con, sql, params, ts);
            }
            if (close || rollback && !TX.inTX()) {
                if (implicitObject != null) {
                    implicitObject.release();
                }
                this.close(rs);
                this.close(stmt);
                this.close(con, rollback);
            } else {
                ResultSet frs = rs;
                Statement fstmt = stmt;
                resource = new QueryResource(con, sql, () -> {
                    if (implicitObject != null) {
                        implicitObject.release();
                    }
                    this.close(frs);
                    this.close(fstmt);
                });
            }
            return new QueryResult<Object>(result, resource);
        }
        catch (Throwable e) {
            throw KDExceptionKit.wrapRuntimeException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    int update(DBRoute dbRoute, DelegateConnection conn, boolean closeConn, String sql, Object ... params) {
        try (ThreadRouteKeyContext context = ThreadRouteKeyContext.create((String)dbRoute.getRouteKey());){
            int rows;
            Statement stmt;
            boolean rollback;
            block26: {
                sql = this.handleTemptableFacade(dbRoute.getRouteKey(), sql);
                rollback = false;
                stmt = null;
                rows = 0;
                long ts = System.currentTimeMillis();
                try {
                    if (sqlLogger != null) {
                        sqlLogger.logSQL(sql, params);
                    }
                    if (Audit.isEnable()) {
                        this.audit(sql);
                    }
                    if (params == null || params.length == 0) {
                        stmt = conn.createStatement(1003, 1007);
                        stmt.setQueryTimeout(this.getQueryTimeoutSeconds());
                        rows = stmt.executeUpdate(sql);
                        if (Audit.isEnable()) {
                            ForbidHardSQL.audit((String)sql);
                        }
                    } else {
                        stmt = conn.prepareStatement(sql, 1003, 1007);
                        stmt.setQueryTimeout(this.getQueryTimeoutSeconds());
                        stmt.setFetchDirection(1000);
                        stmt.setFetchSize(5000);
                        this.fillStatement((PreparedStatement)stmt, params, conn);
                        rows = ((PreparedStatement)stmt).executeUpdate();
                    }
                    if (!this.enableOutSQL) break block26;
                }
                catch (Throwable e) {
                    try {
                        rollback = true;
                        throw this.rethrow(conn, e, sql, params);
                    }
                    catch (Throwable throwable) {
                        if (this.enableOutSQL) {
                            this.logSQLCost(dbRoute, conn, sql, params, ts);
                        }
                        this.close(stmt);
                        if (!closeConn) {
                            if (!rollback) throw throwable;
                            if (TX.inTX()) throw throwable;
                        }
                        this.close(conn, rollback);
                        throw throwable;
                    }
                }
                this.logSQLCost(dbRoute, conn, sql, params, ts);
            }
            this.close(stmt);
            if (closeConn || rollback && !TX.inTX()) {
                this.close(conn, rollback);
            }
            int n = rows;
            return n;
        }
        catch (Throwable e) {
            throw KDExceptionKit.wrapRuntimeException((Throwable)e);
        }
    }

    @Override
    DefaultPreparedBatch prepareBatch(DBRoute dbRoute, String sql, TraceSpan ts, Auditable audit) {
        return this.prepareBatch(dbRoute, this.getConnection(dbRoute, sql, ts), true, sql, ts, audit);
    }

    private DefaultPreparedBatch prepareBatch(final DBRoute dbRoute, final DelegateConnection conn, final boolean closeConn, final String sql, final TraceSpan ts, final Auditable audit) {
        try {
            final AtomicBoolean closed = new AtomicBoolean(false);
            try {
                final PreparedStatement stmt = conn.prepareStatement(sql, 1003, 1007);
                stmt.setQueryTimeout(this.getQueryTimeoutSeconds());
                stmt.setFetchDirection(1000);
                stmt.setFetchSize(5000);
                return new DefaultPreparedBatch(stmt){
                    private boolean rollback;
                    {
                        super(ps);
                        this.rollback = false;
                    }

                    @Override
                    public void addBatch() {
                        try {
                            stmt.addBatch();
                        }
                        catch (Throwable e) {
                            this.rollback = true;
                            throw KDExceptionKit.wrapRuntimeException((Throwable)e);
                        }
                    }

                    @Override
                    public int[] executeBatch() {
                        long ts2 = System.currentTimeMillis();
                        if (BaseDB.sqlLogger != null) {
                            BaseDB.sqlLogger.logSQL(sql, new Object[0]);
                        }
                        if (Audit.isEnable()) {
                            DBImpl.this.audit(sql);
                        }
                        try {
                            int[] nArray = stmt.executeBatch();
                            return nArray;
                        }
                        catch (Throwable e) {
                            this.rollback = true;
                            throw KDExceptionKit.wrapRuntimeException((Throwable)DBImpl.this.rethrow(conn, e, sql, null));
                        }
                        finally {
                            if (DBImpl.this.enableOutSQL) {
                                DBImpl.this.logSQLCost(dbRoute, conn, sql, (List<Object[]>)null, ts2);
                            }
                        }
                    }

                    @Override
                    public void commitCurrent() {
                        try {
                            conn.commit();
                            this.rollback = false;
                        }
                        catch (Throwable e) {
                            throw KDExceptionKit.wrapRuntimeException((Throwable)e);
                        }
                    }

                    @Override
                    public void close() {
                        if (closed.compareAndSet(false, true)) {
                            try {
                                DBImpl.this.close(stmt);
                                if (closeConn || this.rollback && !TX.inTX()) {
                                    DBImpl.this.close(conn, this.rollback);
                                }
                            }
                            catch (Throwable e) {
                                throw KDExceptionKit.wrapRuntimeException((Throwable)e);
                            }
                            finally {
                                audit.close();
                                ts.close();
                            }
                        }
                    }

                    @Override
                    public void setParams(Object[] params) {
                        try {
                            DBImpl.this.fillStatement(stmt, params, conn);
                        }
                        catch (Throwable e) {
                            this.rollback = true;
                            throw KDExceptionKit.wrapRuntimeException((Throwable)e);
                        }
                    }

                    @Override
                    public void setParam(int index, Object param) {
                        try {
                            DBImpl.this.fillStatement(stmt, index, param, conn);
                        }
                        catch (Throwable e) {
                            this.rollback = true;
                            throw KDExceptionKit.wrapRuntimeException((Throwable)e);
                        }
                    }
                };
            }
            catch (Throwable e) {
                if (!closed.get()) {
                    if (closeConn || !TX.inTX()) {
                        this.close(conn, true);
                    }
                    audit.close();
                    ts.close();
                }
                throw this.rethrow(conn, e, sql, new Object[0]);
            }
        }
        catch (Throwable e) {
            throw KDExceptionKit.wrapRuntimeException((Throwable)e);
        }
    }

    @Override
    PreparedStatement preparedStatement(final DBRoute dbRoute, final String sql, TraceSpan ts, Auditable audit) {
        try {
            final DelegateConnection conn = this.getConnection(dbRoute, sql, ts);
            PreparedStatement stmt = conn.prepareStatement(sql, 1003, 1007);
            stmt.setQueryTimeout(this.getQueryTimeoutSeconds());
            stmt.setFetchDirection(1000);
            stmt.setFetchSize(5000);
            if (sqlLogger != null) {
                sqlLogger.logSQL(sql, new Object[0]);
            }
            if (Audit.isEnable()) {
                this.audit(sql);
            }
            AutoCloseConnPrepareStatement autoCloseConnPrepareStatement = new AutoCloseConnPrepareStatement(stmt, conn){

                public int[] executeBatch() throws SQLException {
                    if (DBImpl.this.enableOutSQL) {
                        long ts = System.currentTimeMillis();
                        int[] ret = super.executeBatch();
                        DBImpl.this.logSQLCost(dbRoute, conn, sql, (List<Object[]>)null, ts);
                        return ret;
                    }
                    return super.executeBatch();
                }
            };
            return autoCloseConnPrepareStatement;
        }
        catch (Exception ex) {
            throw KDExceptionKit.wrapRuntimeException((Throwable)ex);
        }
        finally {
            this.closeIgnoredException((AutoCloseable)audit);
        }
    }

    private void closeIgnoredException(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception ignored) {
            DisCardUtil.discard();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private int[] executeBatch(DBRoute dbRoute, DelegateConnection conn, boolean closeConn, String sql, List<Object[]> paramsList) {
        try {
            Throwable throwable = null;
            try (ThreadRouteKeyContext context = ThreadRouteKeyContext.create((String)dbRoute.getRouteKey());){
                int[] nArray;
                Statement stmt;
                boolean rollback;
                block40: {
                    long ts;
                    block38: {
                        int[] nArray2;
                        block39: {
                            int N;
                            block36: {
                                int[] nArray3;
                                block37: {
                                    sql = this.handleTemptableFacade(dbRoute.getRouteKey(), sql);
                                    if (paramsList == null) {
                                        throw new IllegalArgumentException("ExecuteBatch's paramsList can not be null.");
                                    }
                                    rollback = false;
                                    stmt = null;
                                    ts = System.currentTimeMillis();
                                    if (sqlLogger != null) {
                                        sqlLogger.logSQL(sql, new Object[]{paramsList});
                                    }
                                    if (Audit.isEnable()) {
                                        this.audit(sql);
                                    }
                                    if ((N = paramsList.size()) != 0) break block36;
                                    stmt = conn.createStatement(1003, 1007);
                                    stmt.setQueryTimeout(this.getQueryTimeoutSeconds());
                                    stmt.setFetchDirection(1000);
                                    stmt.setFetchSize(5000);
                                    stmt.execute(sql);
                                    if (Audit.isEnable()) {
                                        ForbidHardSQL.audit((String)sql);
                                    }
                                    nArray3 = new int[]{stmt.getUpdateCount()};
                                    if (!this.enableOutSQL) break block37;
                                    this.logSQLCost(dbRoute, conn, sql, paramsList, ts);
                                }
                                this.close(stmt);
                                if (closeConn || rollback && !TX.inTX()) {
                                    this.close(conn, rollback);
                                }
                                return nArray3;
                            }
                            stmt = conn.prepareStatement(sql, 1003, 1007);
                            stmt.setQueryTimeout(this.getQueryTimeoutSeconds());
                            stmt.setFetchDirection(1000);
                            stmt.setFetchSize(5000);
                            if (N != 1) break block38;
                            Object[] params = paramsList.get(0);
                            this.fillStatement((PreparedStatement)stmt, params, conn);
                            ((PreparedStatement)stmt).execute();
                            nArray2 = new int[]{stmt.getUpdateCount()};
                            if (!this.enableOutSQL) break block39;
                            this.logSQLCost(dbRoute, conn, sql, paramsList, ts);
                        }
                        this.close(stmt);
                        if (closeConn || rollback && !TX.inTX()) {
                            this.close(conn, rollback);
                        }
                        return nArray2;
                    }
                    try {
                        Statement finalStmt = stmt;
                        nArray = this.splitExecuteBatch(paramsList, shardParamsList -> {
                            if (XDBConfig.paramUseOpenGaussFiller()) {
                                ParameterFillerFactory.get((DBType)conn.getDBType()).fillBatch(conn.getDBType(), false, (PreparedStatement)finalStmt, shardParamsList);
                            } else {
                                ParameterSetter.fillBatch((boolean)false, (PreparedStatement)((PreparedStatement)finalStmt), (List)shardParamsList);
                            }
                            return finalStmt.executeBatch();
                        });
                        if (!this.enableOutSQL) break block40;
                    }
                    catch (Throwable e) {
                        try {
                            try {
                                rollback = true;
                                throw this.rethrow(conn, e, sql, paramsList.toArray());
                            }
                            catch (Throwable throwable2) {
                                if (this.enableOutSQL) {
                                    this.logSQLCost(dbRoute, conn, sql, paramsList, ts);
                                }
                                this.close(stmt);
                                if (closeConn || rollback && !TX.inTX()) {
                                    this.close(conn, rollback);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                    }
                    this.logSQLCost(dbRoute, conn, sql, paramsList, ts);
                }
                this.close(stmt);
                if (closeConn || rollback && !TX.inTX()) {
                    this.close(conn, rollback);
                }
                return nArray;
            }
        }
        catch (Throwable e) {
            throw KDExceptionKit.wrapRuntimeException((Throwable)e);
        }
    }

    @Override
    <T> T callWithExtContext(DBRoute dbRoute, boolean readOnly, Callable<T> callable) throws Exception {
        return callable.call();
    }

    private void fillStatement(PreparedStatement stmt, int index, Object param, DelegateConnection conn) throws SQLException {
        if (param != null) {
            try {
                if (XDBConfig.paramUseOpenGaussFiller()) {
                    ParameterFillerFactory.get((DBType)conn.getDBType()).set(stmt, param, index + 1);
                }
                ParameterSetter.set((PreparedStatement)stmt, (Object)param, (int)(index + 1));
            }
            catch (SQLException e) {
                String msg = "ParameterSetter.set error: pos=" + (index + 1) + ",value=" + param + ", type=" + param.getClass().getName();
                throw SecureExceptionUtil.wrapSQLException((SQLException)new SQLException(msg, e));
            }
        } else {
            stmt.setNull(index + 1, 0);
        }
    }

    private void fillStatement(PreparedStatement stmt, Object[] params, DelegateConnection conn) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            this.fillStatement(stmt, i, params[i], conn);
        }
    }

    @Override
    List<ExtractQuery> extractQuery(DBRoute dbRoute, String sql, Object[] params, TraceSpan ts) throws SQLException {
        try (DelegateConnection con = this.getConnection(dbRoute, sql, ts);){
            ArrayList<ExtractQuery> ret = new ArrayList<ExtractQuery>(1);
            String dialectSQL = "/*dialect*/" + KSqlTransferImpl.instance.trans(sql, con.getDBType());
            ret.add(new ExtractQueryImpl(dbRoute, dialectSQL, params));
            ArrayList<ExtractQuery> arrayList = ret;
            return arrayList;
        }
    }

    private String handleTemptableFacade(String routeKey, String sql) {
        TemptableFacadeContext context = TemptableFacadeContexts.get();
        if (context == null || context.isTableListEmpty()) {
            return sql;
        }
        TemptableFacadeResolver resolver = new TemptableFacadeResolver(context, TemptableManager.get());
        return resolver.resolve(routeKey, sql);
    }

    @Override
    QueryTimeout timeout(int seconds) {
        TimeoutImpl to = new TimeoutImpl(seconds, thTimeout.get());
        thTimeout.set(to);
        return to;
    }

    private int getQueryTimeoutSeconds() {
        int webRequestTimeout = DBTimeoutHandler.handleGovRequestTimeout();
        int queryTimeout = thTimeout.get() != null ? thTimeout.get().getSeconds() : this.queryTimeoutSeconds;
        return Math.min(webRequestTimeout, queryTimeout);
    }

    private static class TimeoutImpl
    implements QueryTimeout {
        private int seconds;
        private QueryTimeout parent;

        public TimeoutImpl(int seconds, QueryTimeout parent) {
            this.seconds = seconds;
            this.parent = parent;
        }

        public void close() {
            if (this.parent != null) {
                thTimeout.set(this.parent);
            } else {
                thTimeout.remove();
            }
        }

        public int getSeconds() {
            return this.seconds;
        }
    }
}

