/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.xdb.tablemanager.TableName;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public final class DBRoute {
    public static final DBRoute basedata;
    public static final DBRoute base;
    public static final DBRoute main;
    public static final DBRoute meta;
    public static final DBRoute workflow;
    public static final DBRoute log;
    public static final DBRoute permission;
    public static final DBRoute qing;
    private static final Map<String, DBRoute> sharedDBRouteMap;
    private final String routeKey;
    private Map<String, String> tableRouteMap;

    public static DBRoute of(String routeKey) {
        DBRoute route = sharedDBRouteMap.get(routeKey = routeKey == null ? "" : routeKey.trim().toLowerCase());
        if (route == null) {
            route = sharedDBRouteMap.computeIfAbsent(routeKey, key -> new DBRoute((String)key));
        }
        return route;
    }

    public static String getRouteKey(DBRoute dbRoute) {
        return dbRoute == null ? "" : dbRoute.getRouteKey();
    }

    public DBRoute(String routeKey) {
        this.routeKey = routeKey == null ? "" : routeKey.trim().toLowerCase();
    }

    @SdkInternal
    public boolean isRoot() {
        return this.routeKey.indexOf(46) == -1;
    }

    @SdkInternal
    public DBRoute parent() {
        int p = this.routeKey.indexOf(46);
        if (p == -1) {
            return null;
        }
        return DBRoute.of(this.routeKey.substring(0, p));
    }

    public String getRouteKey() {
        return this.routeKey;
    }

    @SdkInternal
    public synchronized String getTableRouteKey(String table) {
        String routeKey;
        if (this.tableRouteMap != null && (routeKey = this.tableRouteMap.get(table = TableName.of((String)table.trim()).getOriginalName())) != null) {
            return routeKey;
        }
        return this.routeKey;
    }

    @SdkInternal
    public synchronized DBRoute setTableRouteKey(String table, String tableRouteKey) {
        if (this.tableRouteMap == null) {
            this.tableRouteMap = new HashMap<String, String>();
        }
        table = TableName.of((String)table.trim()).getOriginalName();
        this.tableRouteMap.put(table, tableRouteKey);
        return this;
    }

    @SdkInternal
    public synchronized boolean hasEmptyTableRouteKey() {
        return this.tableRouteMap == null || this.tableRouteMap.size() == 0;
    }

    @SdkInternal
    public synchronized DBRoute copy(String newRouteKey) {
        DBRoute c = new DBRoute(newRouteKey);
        if (!this.hasEmptyTableRouteKey()) {
            c.tableRouteMap = new HashMap<String, String>(this.tableRouteMap);
        }
        return c;
    }

    @SdkInternal
    public String toString() {
        return this.routeKey + "(" + (this.tableRouteMap == null ? "{}" : this.tableRouteMap) + ")";
    }

    static {
        base = basedata = new DBRoute("basedata");
        main = basedata;
        meta = new DBRoute("sys.meta");
        workflow = new DBRoute("wf");
        log = new DBRoute("log");
        permission = new DBRoute("permission");
        qing = new DBRoute("qing");
        sharedDBRouteMap = new ConcurrentHashMap<String, DBRoute>();
        sharedDBRouteMap.put(basedata.getRouteKey(), basedata);
        sharedDBRouteMap.put(meta.getRouteKey(), meta);
        sharedDBRouteMap.put(workflow.getRouteKey(), workflow);
        sharedDBRouteMap.put(log.getRouteKey(), log);
        sharedDBRouteMap.put(permission.getRouteKey(), permission);
        sharedDBRouteMap.put(qing.getRouteKey(), qing);
    }
}

