/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db;

import com.mysql.cj.exceptions.CJException;
import com.mysql.cj.exceptions.CJTimeoutException;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLTimeoutException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.function.Function;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.db.tx.TX;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.exception.SecureExceptionUtil;
import kd.bos.exception.XDBErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.exception.LimitedSQLException;

class ExceptionWrapper {
    private static final Log logger = LogFactory.getLog(ExceptionWrapper.class);
    private static final int SUB_SQL_LENGTH_FOR_RETHROW = 1024;
    private static final int SUB_SQL_LENGTH_FOR_LOG = 10240;
    static final int SUB_PARAMETER_COUNT_FOR_RETHROW = 50;
    private static final int SUB_PARAMETER_COUNT_FOR_LOG = 1000;
    private DelegateConnection conn;
    private Throwable cause;
    private String sql;
    private Object[] params;
    private boolean logWithSql;
    private boolean logWithParameter;
    private boolean errorLogWithConnection;
    private boolean throwWithConnectionLifeCycle;
    private ShowExceptionMode showExceptionMode;
    private String causeMessage;
    private Throwable logCause;
    private Throwable rethrowCause;
    private ErrorCode errorCode;
    private boolean hasWrapperCause = false;

    private ExceptionWrapper() {
    }

    private void wrapper() {
        if (this.hasWrapperCause) {
            return;
        }
        if (!this.causeHasWrapped()) {
            this.wrapperLogCause();
            this.wrapperRethrowCause();
        }
        this.hasWrapperCause = true;
    }

    private boolean causeHasWrapped() {
        SQLException e;
        String string = this.causeMessage = this.cause == null ? "" : this.cause.getMessage();
        if (this.causeMessage == null) {
            this.causeMessage = "";
        }
        if (this.cause instanceof SQLException && "22007".equals((e = (SQLException)this.cause).getSQLState())) {
            this.logCause = this.rethrowCause = SecureExceptionUtil.wrapSQLException((SQLException)new SQLException("Input data format error or charset unsupported: " + this.causeMessage, e.getSQLState(), e.getErrorCode(), this.cause));
            this.errorCode = BosErrorCode.sQL;
            return true;
        }
        if (this.cause instanceof KDException) {
            ErrorCode[] hasCheckedErrorCode;
            KDException kdException = (KDException)this.cause;
            for (ErrorCode code : hasCheckedErrorCode = new ErrorCode[]{BosErrorCode.sQL, BosErrorCode.sQLRWTimeOut, BosErrorCode.sQLDuplicateKey}) {
                if (!code.equals((Object)kdException.getErrorCode())) continue;
                this.logCause = this.rethrowCause = kdException;
                this.errorCode = kdException.getErrorCode();
                return true;
            }
        }
        return false;
    }

    public Throwable getLogCause() {
        this.wrapper();
        return this.logCause;
    }

    public Throwable getRethrowCause() {
        this.wrapper();
        return this.rethrowCause;
    }

    private void wrapperLogCause() {
        StringBuilder msg = new StringBuilder(4096);
        this.appendErrorLogWithConnection(msg);
        msg.append(this.causeMessage);
        this.appendContextAndStack(msg);
        this.appendSubSQL(msg, 10240);
        this.appendSubParameter(msg, 1000);
        this.appendConnectionLifeCycle(msg);
        this.logCause = this.wrapSQLException(this.cause, msg.toString(), true);
    }

    private void wrapperRethrowCause() {
        StringBuilder msg = new StringBuilder(4096);
        String dbException = "Database execute exception.";
        switch (this.showExceptionMode) {
            case DEBUG: {
                this.appendErrorLogWithConnection(msg);
                msg.append(this.causeMessage);
                this.appendContextAndStack(msg);
                this.appendSubSQL(msg, 1024);
                this.appendSubParameter(msg, 50);
                this.appendConnectionLifeCycle(msg);
                this.rethrowCause = this.wrapSQLException(this.cause, msg.toString(), true);
                break;
            }
            default: {
                msg.append(dbException);
                this.appendContextAndStack(msg);
                this.rethrowCause = this.wrapSQLException(this.cause, msg.toString(), false);
                break;
            }
            case SAFE: {
                msg.append("Database execute exception.");
                this.rethrowCause = this.wrapSQLException(this.cause, msg.toString(), false);
            }
        }
    }

    private void appendErrorLogWithConnection(StringBuilder msg) {
        DBConfig dbconfig = this.conn.getDBConfig();
        if (this.errorLogWithConnection) {
            msg.append('[').append(dbconfig.getTenantId()).append('@').append(dbconfig.getRouteKey()).append(", ").append(dbconfig.getUser()).append('@').append(dbconfig.getIp()).append(':').append(dbconfig.getPort()).append('/').append(dbconfig.getSchema()).append("] ");
        }
    }

    private void appendContextAndStack(StringBuilder msg) {
        RequestContextInfo rc = RequestContextInfo.get();
        msg.append("\nRequestContext: tenantId=").append(rc.getTenantId()).append(", accountId=").append(rc.getAccountId());
        String setStack = RequestContextInfo.getRequestContextSetStack();
        if (setStack != null) {
            msg.append("\nRequestContext.setStack: ").append(setStack);
        }
        msg.append("\nTX: ").append(TX.__getTXContext());
    }

    private void appendSubSQL(StringBuilder msg, int subLength) {
        if (this.logWithSql) {
            String subSQL = this.sql.length() <= subLength ? this.sql : this.sql.substring(0, subLength) + " ...";
            msg.append("\nSQL: ");
            msg.append(subSQL);
        }
    }

    private void appendParameter(Object[] tmpParams, StringBuilder msg) {
        if (this.logWithParameter) {
            msg.append("\nParameters: ");
            if (tmpParams == null) {
                msg.append("[]");
            } else {
                msg.append(Arrays.deepToString(this.deepHandleStringObjects(tmpParams)));
            }
        }
    }

    private Object[] deepHandleStringObjects(Object[] objects) {
        Object[] tmp = Arrays.copyOf(objects, objects.length);
        for (int i = 0; i < objects.length; ++i) {
            Object o = tmp[i];
            if (o instanceof String) {
                tmp[i] = "'" + o + "'";
                continue;
            }
            if (o == null || !o.getClass().isArray()) continue;
            try {
                Class<?> componentType = o.getClass().getComponentType();
                if (componentType == Object.class) {
                    tmp[i] = this.deepHandleStringObjects((Object[])o);
                    continue;
                }
                if (componentType != String.class) continue;
                tmp[i] = this.deepHandleStringObjects(Arrays.stream((String[])o).toArray());
                continue;
            }
            catch (Exception e) {
                logger.error("DB deepHandleStringObjects error:" + e.getMessage(), (Throwable)e);
            }
        }
        return tmp;
    }

    private void appendSubParameter(StringBuilder msg, int subLength) {
        if (this.params == null || this.params.length <= subLength) {
            this.appendParameter(this.params, msg);
        } else {
            Object[] subParameter = Arrays.copyOf(this.params, subLength);
            this.appendParameter(subParameter, msg);
            msg.insert(msg.length() - 1, ", ...");
        }
    }

    private void appendConnectionLifeCycle(StringBuilder msg) {
        if (this.throwWithConnectionLifeCycle && (this.causeMessage.contains("unexpected end of stream") || this.causeMessage.contains("Server has closed the connection"))) {
            msg.append('\n').append(this.conn.getLifeCycleMessage());
        }
    }

    private KDException wrapSQLException(Throwable cause, String msg, boolean retainSourceCause) {
        SQLException e;
        if (retainSourceCause) {
            if (cause instanceof SQLException) {
                SQLException sqlException = (SQLException)cause;
                e = new SQLException(msg, sqlException.getSQLState(), sqlException.getErrorCode(), cause);
            } else if (cause instanceof CJException) {
                CJException cjEx = (CJException)cause;
                e = new SQLException(msg, cjEx.getSQLState(), cjEx.getVendorCode(), cause);
            } else {
                e = new SQLException(msg, cause);
            }
        } else {
            e = new SQLException(msg);
        }
        if (this.errorCode == null) {
            this.errorCode = this.sqlException2ErrorCode(cause, this.conn.getDBType());
        }
        if (this.errorCode == BosErrorCode.sQLRWTimeOut) {
            return SecureExceptionUtil.wrapSQLTimeoutException((SQLException)e);
        }
        if (this.errorCode == BosErrorCode.sQLDuplicateKey) {
            return SecureExceptionUtil.wrapDuplicateKeyException((SQLException)e);
        }
        if (this.errorCode == XDBErrorCode.exceedShardingTableQueryLimit) {
            return SecureExceptionUtil.wrapExceedShardingTbQueryLimitException((SQLException)e);
        }
        if (this.errorCode == XDBErrorCode.xdbMultiDBWrited) {
            return SecureExceptionUtil.wrapXdbMultiDBWrited((SQLException)e);
        }
        if (this.errorCode == XDBErrorCode.xdbRouteInconsistency) {
            return SecureExceptionUtil.wrapXdbRouteInconsistency((SQLException)e);
        }
        if (this.errorCode != null) {
            return SecureExceptionUtil.wrapSQLException((ErrorCode)this.errorCode, (SQLException)e);
        }
        return SecureExceptionUtil.wrapSQLException((SQLException)e);
    }

    private ErrorCode eachThrowable(Throwable cause, Function<Throwable, ErrorCode> opt) {
        if (opt == null || cause == null) {
            return BosErrorCode.sQL;
        }
        HashSet<Throwable> his = new HashSet<Throwable>();
        for (Throwable c = cause; c != null && his.add(c); c = c.getCause()) {
            if (c instanceof SQLTimeoutException) {
                return BosErrorCode.sQLRWTimeOut;
            }
            if (c instanceof SQLIntegrityConstraintViolationException) {
                return BosErrorCode.sQLDuplicateKey;
            }
            if (c instanceof LimitedSQLException) {
                return ((LimitedSQLException)c).getErrorCode();
            }
            ErrorCode r = opt.apply(c);
            if (r == null) continue;
            return r;
        }
        return BosErrorCode.sQL;
    }

    private ErrorCode mysqlException2ErrorCode(Throwable cause) {
        return this.eachThrowable(cause, throwable -> {
            if (throwable instanceof CJTimeoutException) {
                return BosErrorCode.sQLRWTimeOut;
            }
            int vendorCode = -1;
            if (throwable instanceof CJException) {
                CJException cj = (CJException)throwable;
                vendorCode = cj.getVendorCode();
            } else if (throwable instanceof SQLException) {
                SQLException sqlEx = (SQLException)throwable;
                vendorCode = sqlEx.getErrorCode();
            }
            if (vendorCode == 1317 || vendorCode == 1205) {
                return BosErrorCode.sQLRWTimeOut;
            }
            if (vendorCode == 1062) {
                return BosErrorCode.sQLDuplicateKey;
            }
            if (vendorCode == 1146) {
                return BosErrorCode.sQLTableNotExist;
            }
            return null;
        });
    }

    private ErrorCode oracleException2ErrorCode(Throwable cause) {
        return this.eachThrowable(cause, throwable -> {
            if (throwable instanceof BatchUpdateException) {
                if (throwable.getMessage().startsWith("ORA-01013")) {
                    return BosErrorCode.sQLRWTimeOut;
                }
                if (throwable.getMessage().startsWith("ORA-00001")) {
                    return BosErrorCode.sQLDuplicateKey;
                }
            } else if (throwable instanceof SQLException) {
                SQLException sqlEx = (SQLException)throwable;
                if (sqlEx.getErrorCode() == 1013) {
                    return BosErrorCode.sQLRWTimeOut;
                }
                if (throwable.getMessage().startsWith("ORA-00001")) {
                    return BosErrorCode.sQLDuplicateKey;
                }
                if (sqlEx.getErrorCode() == 942) {
                    return BosErrorCode.sQLTableNotExist;
                }
            }
            return null;
        });
    }

    private ErrorCode vastbaseException2ErrorCode(Throwable cause) {
        return this.eachThrowable(cause, throwable -> {
            if (throwable instanceof SQLException) {
                SQLException sqlEx = (SQLException)throwable;
                if ("57014".equalsIgnoreCase(sqlEx.getSQLState())) {
                    return BosErrorCode.sQLRWTimeOut;
                }
                if ("23505".equalsIgnoreCase(sqlEx.getSQLState())) {
                    return BosErrorCode.sQLDuplicateKey;
                }
                if ("42P01".equalsIgnoreCase(sqlEx.getSQLState())) {
                    return BosErrorCode.sQLTableNotExist;
                }
            }
            return null;
        });
    }

    private ErrorCode pgException2ErrorCode(Throwable cause) {
        return this.eachThrowable(cause, throwable -> {
            if (throwable instanceof SQLException) {
                SQLException sqlEx = (SQLException)throwable;
                if ("57014".equalsIgnoreCase(sqlEx.getSQLState())) {
                    return BosErrorCode.sQLRWTimeOut;
                }
                if ("23505".equalsIgnoreCase(sqlEx.getSQLState())) {
                    return BosErrorCode.sQLDuplicateKey;
                }
                if ("42P01".equalsIgnoreCase(sqlEx.getSQLState())) {
                    return BosErrorCode.sQLTableNotExist;
                }
            }
            return null;
        });
    }

    private ErrorCode sqlServerException2ErrorCode(Throwable cause) {
        return this.eachThrowable(cause, throwable -> {
            if (throwable instanceof SQLException) {
                SQLException sqlEx = (SQLException)throwable;
                if ("HY008".equalsIgnoreCase(sqlEx.getSQLState())) {
                    return BosErrorCode.sQLRWTimeOut;
                }
                if (sqlEx.getErrorCode() == 2627) {
                    return BosErrorCode.sQLDuplicateKey;
                }
                if ("23000".equalsIgnoreCase(sqlEx.getSQLState())) {
                    return BosErrorCode.sQLDuplicateKey;
                }
                if ("S0002".equalsIgnoreCase(sqlEx.getSQLState())) {
                    return BosErrorCode.sQLTableNotExist;
                }
            }
            return null;
        });
    }

    private ErrorCode dmException2ErrorCode(Throwable cause) {
        return this.eachThrowable(cause, throwable -> {
            if (throwable instanceof SQLException) {
                SQLException sqlEx = (SQLException)throwable;
                if (sqlEx.getErrorCode() == -608) {
                    return BosErrorCode.sQLRWTimeOut;
                }
                if (sqlEx.getErrorCode() == -6602) {
                    return BosErrorCode.sQLDuplicateKey;
                }
                if (sqlEx.getErrorCode() == -2106) {
                    return BosErrorCode.sQLTableNotExist;
                }
            }
            return null;
        });
    }

    private ErrorCode sqlException2ErrorCode(Throwable cause, DBType dbType) {
        if (cause instanceof SQLTimeoutException) {
            return BosErrorCode.sQLRWTimeOut;
        }
        if (cause instanceof SQLIntegrityConstraintViolationException) {
            return BosErrorCode.sQLDuplicateKey;
        }
        if (dbType == DBType.mysql) {
            return this.mysqlException2ErrorCode(cause);
        }
        if (dbType == DBType.oracle) {
            return this.oracleException2ErrorCode(cause);
        }
        if (dbType == DBType.sqlserver) {
            return this.sqlServerException2ErrorCode(cause);
        }
        if (dbType == DBType.postgresql) {
            return this.pgException2ErrorCode(cause);
        }
        if (dbType == DBType.dm) {
            return this.dmException2ErrorCode(cause);
        }
        if (dbType == DBType.vastbase) {
            return this.vastbaseException2ErrorCode(cause);
        }
        return BosErrorCode.sQL;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static /* synthetic */ Object[] access$402(ExceptionWrapper x0, Object[] x1) {
        x0.params = x1;
        return x1;
    }

    static enum ShowExceptionMode {
        SAFE,
        STRICT,
        DEBUG;

    }

    static class Builder {
        private ExceptionWrapper wrapper = new ExceptionWrapper();

        Builder() {
        }

        public Builder setConn(DelegateConnection conn) {
            this.wrapper.conn = conn;
            return this;
        }

        public Builder setCause(Throwable cause) {
            this.wrapper.cause = cause;
            return this;
        }

        public Builder setSql(String sql) {
            this.wrapper.sql = sql;
            return this;
        }

        public Builder setParams(Object[] params) {
            ExceptionWrapper.access$402(this.wrapper, params);
            return this;
        }

        public Builder setLogWithSql(boolean logWithSql) {
            this.wrapper.logWithSql = logWithSql;
            return this;
        }

        public Builder setLogWithParameter(boolean logWithParameter) {
            this.wrapper.logWithParameter = logWithParameter;
            return this;
        }

        public Builder setErrorLogWithConnection(boolean errorLogWithConnection) {
            this.wrapper.errorLogWithConnection = errorLogWithConnection;
            return this;
        }

        public Builder setThrowWithConnectionLifeCycle(boolean throwWithConnectionLifeCycle) {
            this.wrapper.throwWithConnectionLifeCycle = throwWithConnectionLifeCycle;
            return this;
        }

        public Builder setShowExceptionMode(ShowExceptionMode mode) {
            this.wrapper.showExceptionMode = mode;
            return this;
        }

        public ExceptionWrapper build() {
            return this.wrapper;
        }
    }
}

