/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.algo.dataset.RowFactory;

public class PeekingDataSet {
    private final String algoKey;
    private final List<Object[]> peekingValues;
    private final RowMeta rowMeta;
    private final int size;
    private boolean withRemainingData;
    private DataSet remaining;
    private DataSetCreator dataSetCreator;
    private DataSet dataSet;
    private List<DataSet.Listener> listeners = new ArrayList<DataSet.Listener>();

    public PeekingDataSet(String algoKey, ResultSet rs, RowMeta rowMeta, int peekingSize) throws SQLException {
        this.algoKey = algoKey;
        this.peekingValues = new LinkedList<Object[]>();
        this.rowMeta = rowMeta;
        int i = 0;
        while (i++ < peekingSize && rs.next()) {
            AbstractRow row = ((AbstractRow)RowFactory.createRow((RowMeta)rowMeta, (ResultSet)rs)).persist();
            this.peekingValues.add(row.values());
        }
        this.size = this.peekingValues.size();
        boolean bl = this.withRemainingData = this.size == peekingSize;
        if (this.withRemainingData) {
            this.remaining = Algo.create((String)algoKey).createDataSet(rs, rowMeta);
        }
    }

    public PeekingDataSet(String algoKey, List<Object[]> peekingValues, DataSet remaining) {
        this.peekingValues = peekingValues;
        this.remaining = remaining;
        this.algoKey = algoKey;
        this.rowMeta = remaining.getRowMeta();
        this.size = peekingValues.size();
    }

    public PeekingDataSet(String algoKey, List<Object[]> peekingValues, DataSet remaining, RowMeta rowMeta) {
        this.peekingValues = peekingValues;
        this.remaining = remaining;
        this.algoKey = algoKey;
        this.rowMeta = rowMeta;
        this.size = peekingValues.size();
    }

    public RowMeta getRowMeta() {
        return this.rowMeta;
    }

    public DataSet getRemaining() {
        return this.remaining;
    }

    public List<Object[]> getPeekingValues() {
        return this.peekingValues;
    }

    private DataSet createFetchedDataSet() {
        return Algo.create((String)this.algoKey).createDataSet(this.peekingValues.iterator(), this.rowMeta);
    }

    public DataSet getDataSet() {
        if (this.dataSet == null) {
            this.dataSet = this.dataSetCreator != null ? this.dataSetCreator.create(this.createFetchedDataSet(), this.remaining, this.withRemainingData) : (this.remaining != null ? this.createFetchedDataSet().union(this.remaining) : this.createFetchedDataSet());
            for (DataSet.Listener l : this.listeners) {
                this.dataSet.addListener(l);
            }
        }
        return this.dataSet;
    }

    public int getPeekingRowCount() {
        return this.size;
    }

    public Iterator<Object> peekingRowFieldIterator(String field) {
        return this.peekingRowFieldIterator(field, -1);
    }

    public Iterator<Object> peekingRowFieldIterator(String field, int fieldIndex) {
        final int i = fieldIndex == -1 ? this.rowMeta.getFieldIndex(field) : fieldIndex;
        final Iterator<Object[]> iter = this.peekingValues.iterator();
        return new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public Object next() {
                return ((Object[])iter.next())[i];
            }
        };
    }

    public DataSetCreator getDataSetCreator() {
        return this.dataSetCreator;
    }

    public void setDataSetCreator(DataSetCreator dataSetCreator) {
        this.dataSetCreator = dataSetCreator;
    }

    public void addListener(DataSet.Listener l) {
        this.listeners.add(l);
    }

    public static interface RowMetaDataTypeSetter {
        public void setDataType(DataSet var1, DataSet var2, DataSet var3);
    }

    public static interface DataSetCreator {
        public DataSet create(DataSet var1, DataSet var2, boolean var3);
    }
}

