/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db;

import java.sql.SQLException;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.util.DisCardUtil;
import kd.bos.xdb.exception.ExceptionUtil;

public final class QueryResource
implements AutoCloseable {
    private final DelegateConnection con;
    private final String name;
    private final AutoCloseable beforeReleaseListener;
    private String traceStack;

    public QueryResource(DelegateConnection con, String name, AutoCloseable beforeReleaseListener) {
        this.con = con;
        this.name = name;
        this.beforeReleaseListener = beforeReleaseListener;
        con.addReleaseResource(this);
    }

    public String getName() {
        return this.name;
    }

    public AutoCloseable getBeforeReleaseListener() {
        return this.beforeReleaseListener;
    }

    @Override
    public void close() {
        if (this.con.removeReleaseResource(this)) {
            try {
                this.beforeReleaseListener.close();
            }
            catch (Exception e) {
                throw ExceptionUtil.asRuntimeException((Throwable)e);
            }
        }
    }

    public void closeWithConnection() {
        if (this.con.removeReleaseResource(this)) {
            try {
                this.beforeReleaseListener.close();
            }
            catch (Exception e) {
                throw ExceptionUtil.asRuntimeException((Throwable)e);
            }
            finally {
                try {
                    this.con.close();
                }
                catch (SQLException e) {
                    DisCardUtil.discard();
                }
            }
        }
    }

    public String getTraceStack() {
        return this.traceStack;
    }

    public void setTraceStack(String traceStack) {
        this.traceStack = traceStack;
    }

    public String toString() {
        return this.name;
    }
}

