/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db;

import java.lang.reflect.Method;
import kd.bos.bundle.Resources;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.archive.ArchiveRoute;
import kd.bos.db.tx.RWTableInfo;
import kd.bos.db.tx.TX;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.ParallelExecuteContext;

class RequestParallelExecuteContext
implements ParallelExecuteContext {
    private static Log logger = LogFactory.getLog(RequestParallelExecuteContext.class);
    private static Class<?> requestContextCls;
    private static Method requestContext_get;
    private static Method requestContext_set;
    private static Class<?> requestContextThreadBinder;
    private static Method requestContextThreadBinder_bind;
    private static final Object[] nullParameters;
    private Object rc;
    private ArchiveRoute ar;

    RequestParallelExecuteContext() {
    }

    public void init() {
        try {
            this.rc = requestContext_get.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        if (this.rc == null) {
            IllegalThreadStateException e = new IllegalThreadStateException(Resources.get((String)"bos-dbengine", (String)"RequestParallelExecuteContext_0", (String)"RequestContext\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u7ebf\u7a0b\u73af\u5883\u662f\u5426\u6b63\u786e\u3002", (Object[])new Object[0]));
            throw e;
        }
    }

    public void setup() {
        try {
            requestContext_set.invoke(null, this.rc);
            requestContextThreadBinder_bind.invoke(null, this.rc);
            this.ar = ArchiveRoute.get();
            if (this.ar != null) {
                this.ar = this.ar.isEffective() ? ArchiveRoute.mapRoute(this.ar.getRouteKey(), this.ar.getArchiveRouteKey()) : null;
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public void clear() {
        try {
            requestContext_set.invoke(null, nullParameters);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        finally {
            if (this.ar != null) {
                this.ar.close();
            }
        }
    }

    public boolean useArchiveRoute(String dbRoute) {
        ArchiveRoute ar = ArchiveRoute.get();
        return ar != null && ar.isEffective() && dbRoute.equals(ar.getRouteKey()) && !dbRoute.equals(ar.getArchiveRouteKey());
    }

    public boolean writtenInTX(String routeKey, String querySQL) {
        if (querySQL == null) {
            return true;
        }
        if (TX.inTX()) {
            RWTableInfo si = RWTableInfo.parseRWTableInfo(querySQL);
            RequestContextInfo rc = RequestContextInfo.get();
            if (!TX.__canQueryOnReadOnlyDB(rc.getTenantId(), routeKey, rc.getAccountId(), si.getAllTables().toArray(new String[si.getAllTables().size()]))) {
                return true;
            }
        }
        return false;
    }

    static {
        try {
            requestContextCls = Class.forName("kd.bos.context.RequestContext");
            requestContext_get = requestContextCls.getMethod("get", new Class[0]);
            requestContext_set = requestContextCls.getMethod("set", requestContextCls);
            requestContext_get.setAccessible(true);
            requestContext_set.setAccessible(true);
            requestContextThreadBinder = Class.forName("kd.bos.context.RequestContextThreadBinder");
            requestContextThreadBinder_bind = requestContextThreadBinder.getMethod("bind", requestContextCls);
            requestContextThreadBinder_bind.setAccessible(true);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        nullParameters = new Object[]{null};
    }
}

