/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.db.SqlParameter;
import kd.bos.xdb.temptable.facade.TemptableFacade;

public class SqlObject {
    private final StringBuilder sql = new StringBuilder(128);
    private final List<SqlParameter> params = new ArrayList<SqlParameter>();
    private final List<TemptableFacade> tempTableReleaseList = new ArrayList<TemptableFacade>();

    public SqlObject() {
    }

    public SqlObject(String sql, SqlParameter[] params) {
        this.setSql(sql);
        this.setParams(params);
    }

    public SqlObject(String sql, SqlParameter[] params, List<TemptableFacade> tempTableReleaseList) {
        this.setSql(sql);
        this.setParams(params);
        this.tempTableReleaseList.addAll(tempTableReleaseList);
    }

    public String getSql() {
        return this.sql.toString();
    }

    public void removeLast(int len) {
        this.sql.setLength(this.sql.length() - len);
    }

    public final void setSql(String sql) {
        this.sql.setLength(0);
        if (sql != null) {
            this.sql.append(sql);
        }
    }

    public SqlParameter[] getParams() {
        return this.params.toArray(new SqlParameter[this.params.size()]);
    }

    public final void setParams(SqlParameter[] params) {
        this.params.clear();
        if (params != null && params.length > 0) {
            this.params.addAll(Arrays.asList(params));
        }
    }

    public SqlObject appendSql(char ch) {
        this.sql.append(ch);
        return this;
    }

    public SqlObject appendSql(String sql) {
        this.sql.append(sql);
        return this;
    }

    public SqlObject addParam(SqlParameter sp) {
        this.params.add(sp);
        return this;
    }

    public void clearParams() {
        this.params.clear();
    }

    public List<TemptableFacade> getTempTableReleaseList() {
        return this.tempTableReleaseList;
    }

    public String toString() {
        return this.sql + this.params.toString();
    }
}

