/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import kd.bos.bundle.Resources;
import kd.bos.db.tx.DelegateConnection;
import kd.bos.db.tx.DelegateStatement;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.xdb.ParameterSetter;
import kd.bos.xdb.XDBConfig;
import kd.bos.xdb.datasource.ConnectionProvider;
import kd.bos.xdb.datasource.DBType;
import kd.bos.xdb.ext.SelfSetParameter;
import kd.bos.xdb.parameter.ParameterFillerFactory;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class SqlParameter
implements SelfSetParameter {
    private static final long serialVersionUID = 469460344798827280L;
    private static Log logger = LogFactory.getLog(SqlParameter.class);
    @SdkInternal
    public static final int type_string = 12;
    @SdkInternal
    public static final int type_boolean = 16;
    @SdkInternal
    public static final int type_byte = -6;
    @SdkInternal
    public static final int type_short = 5;
    @SdkInternal
    public static final int type_int = 4;
    @SdkInternal
    public static final int type_long = -5;
    @SdkInternal
    public static final int type_decimal = 3;
    @SdkInternal
    public static final int type_timestamp = 93;
    @SdkInternal
    public static final int type_other = 1111;
    private String name;
    private int dbType = 1111;
    private Object value;

    @SdkInternal
    public SqlParameter() {
    }

    @SdkInternal
    public SqlParameter(Object value) {
        this(SqlParameter.getType(value == null ? null : value.getClass()), value);
    }

    @SdkInternal
    public SqlParameter(Class<?> clsType, Object value) {
        this(SqlParameter.getType(clsType), value);
    }

    @SdkInternal
    public SqlParameter(int columnType, Object value) {
        this(null, columnType, value);
    }

    public SqlParameter(String name, int columnType, Object value) {
        this.name = name;
        this.dbType = columnType;
        try {
            switch (columnType) {
                case -7: 
                case 16: {
                    if (value instanceof String) {
                        value = "1".equals((String)value) || Boolean.parseBoolean((String)value);
                        break;
                    }
                    SqlParameter.matchValueType(name, "boolean", value, Boolean.TYPE, Boolean.class);
                    break;
                }
                case -6: {
                    if (value instanceof String) {
                        value = Byte.valueOf((String)value);
                        break;
                    }
                    SqlParameter.matchValueType(name, "byte", value, Byte.TYPE, Byte.class);
                    break;
                }
                case 5: {
                    if (value instanceof String) {
                        value = Short.valueOf((String)value);
                        break;
                    }
                    SqlParameter.matchValueType(name, "short", value, Short.TYPE, Short.class);
                    break;
                }
                case 4: {
                    if (value instanceof String) {
                        value = Integer.valueOf((String)value);
                        break;
                    }
                    SqlParameter.matchValueType(name, "integer", value, Short.TYPE, Short.class, Integer.TYPE, Integer.class);
                    break;
                }
                case -5: {
                    if (value instanceof String) {
                        value = Long.valueOf((String)value);
                        break;
                    }
                    if (value instanceof BigDecimal) {
                        value = ((BigDecimal)value).longValue();
                        break;
                    }
                    SqlParameter.matchValueType(name, "bigint", value, Long.TYPE, Long.class, Integer.TYPE, Integer.class);
                    break;
                }
                case 6: 
                case 7: {
                    if (value instanceof String) {
                        value = Float.valueOf((String)value);
                        break;
                    }
                    SqlParameter.matchValueType(name, "float", value, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class);
                    break;
                }
                case 2: 
                case 3: 
                case 8: {
                    if (value instanceof String) {
                        value = Double.valueOf((String)value);
                        break;
                    }
                    SqlParameter.matchValueType(name, "double", value, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Double.TYPE, Double.class, BigDecimal.class);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.paramError, "SqlParameter init error, columnName:" + name + ", columnType:" + columnType + ", columnValue:" + value + ".", (Throwable)e);
        }
        this.value = value;
    }

    private static void matchValueType(String name, String tag, Object value, Class<?> ... matchClasses) {
        if (value != null) {
            Class<?> cls = value.getClass();
            boolean matched = false;
            for (Class<?> matchCls : matchClasses) {
                if (cls != matchCls) continue;
                matched = true;
                break;
            }
            if (!matched) {
                String tipName = name == null ? "" : name;
                String msg = tipName + Resources.get((String)"bos-dbengine", (String)"SqlParameter_0", (String)"\u8981\u6c42\u53c2\u6570\u7c7b\u578b%1$s, \u5b9e\u9645\u4f20\u5165\u503c\uff1a%2$s type=%3$s", (Object[])new Object[]{tag, value, cls});
                IllegalArgumentException e = new IllegalArgumentException(msg);
                throw e;
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDbType(int dbType) {
        this.dbType = dbType;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public int getDbType() {
        return this.dbType;
    }

    @Override
    public Object getValue() {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value != false ? "1" : "0";
        }
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    @SdkInternal
    public void setValue(PreparedStatement ps, int paramIndex) throws SQLException {
        if (XDBConfig.paramUseOpenGaussFiller()) {
            DBType type = ps instanceof DelegateStatement ? ((DelegateConnection)ps.getConnection()).getDBType() : ConnectionProvider.get().getConnectionHolder().getDBType();
            if (type == null) {
                throw new KDException(BosErrorCode.parse, new Object[]{"SqlParameter setValue Error , Illegal statement: " + ps.getClass()});
            }
            ParameterFillerFactory.get((DBType)type).set(ps, this.getValue(), paramIndex, this.dbType);
            return;
        }
        ParameterSetter.set((PreparedStatement)ps, (Object)this.getValue(), (int)paramIndex, (int)this.dbType);
    }

    private static int getType(Class<?> clsType) {
        return 1111;
    }
}

