/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.adaptation;

import kd.bos.db.DBType;
import kd.bos.db.adaptation.DatabaseAdaptationFactory;
import kd.bos.db.datasource.urlcreator.DataSourceURLCreator;
import kd.bos.db.datasource.urlcreator.DataSourceURLCreatorGaussDBImpl;
import kd.bos.db.datasource.urlcreator.DataSourceURLCreatorPGImpl;
import kd.bos.db.pktemptable.table.PKTempTableOperator;
import kd.bos.db.pktemptable.table.PKTempTableOperatorFactory;

public class DatabaseAdaptationFactoryImpl
implements DatabaseAdaptationFactory {
    private final DataSourceURLCreator pgDataSourceURLCreator = new DataSourceURLCreatorPGImpl();
    private final DataSourceURLCreator gaussDBDataSourceURLCreator = new DataSourceURLCreatorGaussDBImpl();

    @Override
    public DataSourceURLCreator getDataSourceURLCreator(DBType dbType) {
        switch (dbType) {
            case PostgreSQL: {
                return this.pgDataSourceURLCreator;
            }
            case GaussDB: {
                return this.gaussDBDataSourceURLCreator;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public PKTempTableOperator getPKTemptableOperator(DBType dbType) {
        return PKTempTableOperatorFactory.get(dbType);
    }
}

