/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.archive;

import java.util.Locale;
import kd.bos.util.ThreadLocals;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkModule;

@SdkModule(name="kd.bos.archive", desc="\u5f52\u6863\u8def\u7531\u83b7\u53d6")
public final class ArchiveRoute
implements AutoCloseable {
    private static final ThreadLocal<ArchiveRoute> thArchiveRoute = ThreadLocals.create();
    private final ArchiveRoute parent = thArchiveRoute.get();
    private final String routeKey;
    private final String archiveRouteKey;

    public static ArchiveRoute mapRoute(String routeKey, String archiveRouteKey) {
        return new ArchiveRoute(routeKey, archiveRouteKey);
    }

    @SdkInternal
    public static ArchiveRoute get() {
        return thArchiveRoute.get();
    }

    @SdkInternal
    public static String getMapRoute(String routeKey) {
        ArchiveRoute archiveRoute = thArchiveRoute.get();
        if (archiveRoute == null || !routeKey.toLowerCase(Locale.ENGLISH).equals(archiveRoute.routeKey) || archiveRoute.archiveRouteKey == null || archiveRoute.archiveRouteKey.length() == 0) {
            return routeKey;
        }
        return archiveRoute.archiveRouteKey;
    }

    @SdkInternal
    private ArchiveRoute(String routeKey, String archiveRouteKey) {
        this.routeKey = routeKey.trim().toLowerCase(Locale.ENGLISH);
        this.archiveRouteKey = archiveRouteKey.trim().toLowerCase(Locale.ENGLISH);
        thArchiveRoute.set(this);
    }

    @SdkInternal
    public String getRouteKey() {
        return this.routeKey;
    }

    @SdkInternal
    public String getArchiveRouteKey() {
        return this.archiveRouteKey;
    }

    @SdkInternal
    public boolean isEffective() {
        return this.routeKey != null && this.routeKey.length() > 0 && this.archiveRouteKey != null && this.archiveRouteKey.length() > 0;
    }

    @Override
    public void close() {
        if (this.parent == null) {
            thArchiveRoute.remove();
        } else {
            thArchiveRoute.set(this.parent);
        }
    }

    public String toString() {
        return this.routeKey + ':' + this.archiveRouteKey;
    }
}

