/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.archive;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.archive.DBArchiveManager;
import kd.bos.db.archive.DBArchiveRuntime;
import kd.bos.db.archive.IArchiveConfigProvider;
import kd.bos.db.archive.TentantAccountArchiveConfigProvider;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.db.archive.config.ArchiveIndexConfig;
import kd.bos.db.archive.configchanged.DBArchiveConfigNotifier;
import kd.bos.db.archive.configchanged.DBArchiveIndexConfigNotifier;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public final class DBArchiveManagerImpl
implements DBArchiveManager {
    protected static final DBArchiveManagerImpl INSTANCE = new DBArchiveManagerImpl();
    private static final Log log = LogFactory.getLog(DBArchiveManagerImpl.class);
    private IArchiveConfigProvider archiveConfigProvider;

    private DBArchiveManagerImpl() {
    }

    @Override
    public void setup() {
        this.archiveConfigProvider = new TentantAccountArchiveConfigProvider();
        DBArchiveConfigNotifier.registerReloadArchiveConfigListener(ai -> {
            log.info("[DBArchiveConfigNotifier] onReceiveReloadArchiveConfig " + ai);
            DBArchiveRuntime.getArchiveConfigLoader().runWithDBAccessible(() -> this.reloadArchiveConfig(ai.getEntityName()), new RequestContextInfo(ai.getTenantId(), ai.getAccountId()));
        });
        DBArchiveIndexConfigNotifier.registerReloadArchiveIndexConfigListener(ai -> {
            log.info("[DBArchiveConfigNotifier] onReceiveReloadArchiveIndexConfig " + ai);
            DBArchiveRuntime.getArchiveConfigLoader().runWithDBAccessible(() -> this.reloadArchiveIndexConfig(ai.getEntityName()), new RequestContextInfo(ai.getTenantId(), ai.getAccountId()));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int loadArchiveConfigs(boolean forceReload) {
        DBArchiveRuntime runtime = DBArchiveRuntime.get();
        AtomicBoolean configLoaded = runtime.getConfigLoaded();
        if (forceReload || !configLoaded.get()) {
            Object lock;
            Object object = lock = runtime.getConfigLoadLock();
            synchronized (object) {
                AtomicReference<Thread> configLoadThread = runtime.getConfigLoadThread();
                if (configLoadThread.get() != null) {
                    if (configLoadThread.get() == Thread.currentThread()) {
                        return -1;
                    }
                    if (!configLoaded.get()) {
                        try {
                            lock.wait(60000L);
                            if (!configLoaded.get()) {
                                throw new RuntimeException("loadArchiveConfigs wait another thread done timeout(60s): " + configLoadThread.get());
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    return -1;
                }
                configLoadThread.set(Thread.currentThread());
            }
            try {
                Set<ArchiveConfig> configs = DBArchiveRuntime.getArchiveConfigLoader().loadAll();
                this.archiveConfigProvider.clearConfig();
                this.archiveConfigProvider.addConfigs(configs.toArray(new ArchiveConfig[configs.size()]));
                configLoaded.set(true);
                int n = configs.size();
                return n;
            }
            catch (Exception e) {
                this.archiveConfigProvider.clearConfig();
                configLoaded.set(false);
                log.error("loadArchiveConfigError:\t\n" + e.getMessage(), (Throwable)e);
                throw new KDException(new ErrorCode("loadArchiveConfigError", e.getMessage()), new Object[]{e});
            }
            finally {
                Object object2 = lock;
                synchronized (object2) {
                    runtime.getConfigLoadThread().set(null);
                    lock.notifyAll();
                }
            }
        }
        return -1;
    }

    @Override
    public void notifyReloadArchiveConfig(String entityName) {
        DBArchiveConfigNotifier.fireReloadArchiveConfig(entityName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int loadArchiveIndexConfigs(boolean forceReload) {
        DBArchiveRuntime runtime = DBArchiveRuntime.get();
        AtomicBoolean routeLoaded = runtime.getRouteLoaded();
        if (forceReload || !routeLoaded.get()) {
            Object routeLoadLock;
            Object object = routeLoadLock = runtime.getRouteLoadLock();
            synchronized (object) {
                AtomicReference<Thread> routeLoadThread = runtime.getRouteLoadThread();
                if (routeLoadThread.get() != null) {
                    if (routeLoadThread.get() == Thread.currentThread()) {
                        return -1;
                    }
                    if (!routeLoaded.get()) {
                        try {
                            routeLoadLock.wait(60000L);
                            if (!routeLoaded.get()) {
                                throw new RuntimeException("loadArchiveIndexConfigs wait another thread done timeout(60s): " + routeLoadThread.get());
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    return -1;
                }
                routeLoadThread.set(Thread.currentThread());
            }
            try {
                Set<ArchiveIndexConfig> configs = DBArchiveRuntime.getArchiveConfigLoader().loadIndexAll();
                DBArchiveManager.get().getArchiveConfigProvider().clearIndexConfig();
                DBArchiveManager.get().getArchiveConfigProvider().addIndexConfigs(configs.toArray(new ArchiveIndexConfig[configs.size()]));
                routeLoaded.set(true);
                int n = configs.size();
                return n;
            }
            catch (Exception e) {
                DBArchiveManager.get().getArchiveConfigProvider().clearIndexConfig();
                routeLoaded.set(false);
                log.error("loadArchiveIndexConfigs:\t\n" + e.getMessage(), (Throwable)e);
                throw new KDException(new ErrorCode("loadArchiveIndexConfigs", e.getMessage()), new Object[]{e});
            }
            finally {
                Object object2 = routeLoadLock;
                synchronized (object2) {
                    runtime.getRouteLoadThread().set(null);
                    routeLoadLock.notifyAll();
                }
            }
        }
        return -1;
    }

    @Override
    public void notifyReloadArchiveIndexConfig(String entityName) {
        DBArchiveIndexConfigNotifier.fireReloadArchiveIndexConfig(entityName);
    }

    @Override
    public IArchiveConfigProvider getArchiveConfigProvider() {
        return this.archiveConfigProvider;
    }

    private void reloadArchiveConfig(String entityName) {
        Set<ArchiveConfig> configs = DBArchiveRuntime.getArchiveConfigLoader().load(entityName);
        if (configs != null && !configs.isEmpty()) {
            this.archiveConfigProvider.replaceConfigs(configs.toArray(new ArchiveConfig[configs.size()]));
        } else {
            this.archiveConfigProvider.removeConfigs(DBArchiveRuntime.getArchiveConfigLoader().getEntityMainTable(entityName));
        }
    }

    private void reloadArchiveIndexConfig(String entityName) {
        ArchiveIndexConfig indexConfig = DBArchiveRuntime.getArchiveConfigLoader().loadIndex(entityName);
        if (indexConfig != null) {
            this.archiveConfigProvider.addIndexConfig(indexConfig);
        } else {
            this.archiveConfigProvider.removeIndexConfig(DBArchiveRuntime.getArchiveConfigLoader().getEntityMainTable(entityName));
        }
    }
}

