/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.archive;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.archive.ArchiveConfigLoader;
import kd.bos.db.archive.DBArchiveManager;

public final class DBArchiveRuntime {
    private static final ArchiveConfigLoader archiveConfigLoader;
    private static Method isAccountEnable;
    private static Method loadHasArchiveEntity;
    private static Method loadArchivePlanName;
    private static Method isLogEntity;
    private static final Map<String, DBArchiveRuntime> instanceMap;
    private final AtomicBoolean configLoaded = new AtomicBoolean();
    private final Object configLoadLock = new Object();
    private final AtomicReference<Thread> configLoadThread = new AtomicReference();
    private final AtomicBoolean routeLoaded = new AtomicBoolean();
    private final Object routeLoadLock = new Object();
    private final AtomicReference<Thread> routeLoadThread = new AtomicReference();

    private DBArchiveRuntime() {
    }

    public static DBArchiveRuntime get() {
        RequestContextInfo rci = RequestContextInfo.get();
        String accountId = rci.getAccountId();
        return instanceMap.computeIfAbsent(accountId, key -> new DBArchiveRuntime());
    }

    AtomicBoolean getConfigLoaded() {
        return this.configLoaded;
    }

    AtomicReference<Thread> getConfigLoadThread() {
        return this.configLoadThread;
    }

    Object getConfigLoadLock() {
        return this.configLoadLock;
    }

    public AtomicBoolean getRouteLoaded() {
        return this.routeLoaded;
    }

    public Object getRouteLoadLock() {
        return this.routeLoadLock;
    }

    public AtomicReference<Thread> getRouteLoadThread() {
        return this.routeLoadThread;
    }

    public int loadArchiveConfigs(boolean forceReload) {
        return DBArchiveManager.get().loadArchiveConfigs(forceReload);
    }

    public int loadArchiveIndexConfigs(boolean forceReload) {
        return DBArchiveManager.get().loadArchiveIndexConfigs(forceReload);
    }

    public boolean getArchiveAccountEnable() {
        try {
            return (Boolean)isAccountEnable.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object loadHasArchiveEntity(String entityNumber) {
        try {
            return loadHasArchiveEntity.invoke(null, entityNumber);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object loadArchivePlanName(String archiveRouteKey) {
        try {
            return loadArchivePlanName.invoke(null, archiveRouteKey);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isLogEntity(String entityNumber) {
        try {
            Object obj = isLogEntity.invoke(null, entityNumber);
            if (obj != null) {
                return (Boolean)obj;
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ArchiveConfigLoader getArchiveConfigLoader() {
        return archiveConfigLoader;
    }

    static {
        try {
            archiveConfigLoader = (ArchiveConfigLoader)Class.forName("kd.bos.archive.repository.impl.ArchiveConfigLoaderImpl").newInstance();
            isAccountEnable = Class.forName("kd.bos.archive.config.AccountEnable").getMethod("isAccountEnable", new Class[0]);
            Class<?> aClass = Class.forName("kd.bos.archive.service.ArchiveService");
            loadHasArchiveEntity = aClass.getMethod("loadHasArchiveEntity", String.class);
            loadArchivePlanName = aClass.getMethod("loadArchivePlanName", String.class);
            isLogEntity = aClass.getMethod("isLogEntity", String.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        instanceMap = new ConcurrentHashMap<String, DBArchiveRuntime>();
    }
}

