/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.archive;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bundle.Resources;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.archive.ArchiveInfo;
import kd.bos.db.archive.ArchiveRouteType;
import kd.bos.db.archive.DBArchiveRuntime;
import kd.bos.db.archive.LogicArchiveRoute;
import kd.bos.db.archive.RouteInfo;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.bos.zk.ZKFactory;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkModule;
import org.apache.curator.framework.CuratorFramework;

@SdkModule(name="kd.bos.archive", desc="\u5f52\u6863\u8def\u7531\u83b7\u53d6")
public class MCArchive {
    private static final Log log = LogFactory.getLog((String)"DB");
    private static final String ZK_SEP = "/";
    private static final String ZK_COMMON_PROP_PATH = "config/common/prop";
    private static final String ZK_TENANT_DATA_KEY = "mc.tenant.%s.data";
    private static final Log LOG = LogFactory.getLog((String)"DB");
    @SdkInternal
    public static final String CURRENT_ARCHIVE_ROUTE = "cur_database";
    private static String tenantDataType = "system";

    @SdkInternal
    public static RouteInfo get(String routeKey) {
        long ts = System.currentTimeMillis();
        RouteInfo routeInfo = new RouteInfo();
        try {
            if (StringUtils.isEmpty((String)routeKey) || !DBArchiveRuntime.get().getArchiveAccountEnable()) {
                return routeInfo;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List<RouteInfo> routeInfoList = MCArchive.get();
        for (RouteInfo info : routeInfoList) {
            if (!routeKey.equals(info.getRouteKey())) continue;
            routeInfo = info;
            break;
        }
        if (log.isInfoEnabled()) {
            long ms = System.currentTimeMillis() - ts;
            StringBuilder msg = new StringBuilder("----MCArchive.get(String routeKey)@").append(routeKey).append("->return").append("----\r\n");
            try {
                msg.append(JSONUtils.toString((Object)routeInfo));
            }
            catch (IOException e) {
                LOG.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            msg.append("\r\n").append("#cost:").append(ms).append("ms\r\n");
            log.info(msg.toString());
        }
        return routeInfo;
    }

    public static RouteInfo get(String routeKey, String entityNumber) {
        long ts = System.currentTimeMillis();
        try {
            RouteInfo routeInfo;
            if (StringUtils.isEmpty((String)routeKey) || StringUtils.isEmpty((String)entityNumber) || !DBArchiveRuntime.get().getArchiveAccountEnable()) {
                return new RouteInfo();
            }
            Object obj = DBArchiveRuntime.get().loadHasArchiveEntity(entityNumber);
            if (obj == null) {
                return new RouteInfo();
            }
            Boolean isLogEntity = DBArchiveRuntime.get().isLogEntity(entityNumber);
            Map<Object, Object> existArchiveInfoList = new HashMap();
            boolean enableElastic = false;
            if (isLogEntity.booleanValue()) {
                List<ArchiveInfo> esArchiveInfoList = MCArchive.getESArchiveInfo();
                enableElastic = !esArchiveInfoList.isEmpty();
                existArchiveInfoList = esArchiveInfoList.stream().collect(Collectors.toMap(ArchiveInfo::getKey, archiveInfo -> archiveInfo, (key1, key2) -> key2));
            }
            if (!enableElastic && (routeInfo = MCArchive.get(routeKey)).hasArchiveRoute()) {
                List<ArchiveInfo> archiveInfoList = routeInfo.getArchiveInfo();
                existArchiveInfoList = archiveInfoList.stream().collect(Collectors.toMap(ArchiveInfo::getKey, archiveInfo -> archiveInfo, (key1, key2) -> key2));
            }
            routeInfo = new RouteInfo(routeKey);
            routeInfo.getArchiveInfo().add(MCArchive.getCurrent(routeKey));
            for (String str : (List)obj) {
                LogicArchiveRoute logicArchiveRoute;
                ArchiveInfo archiveInfo2 = (ArchiveInfo)existArchiveInfoList.get(str);
                if (archiveInfo2 == null && (logicArchiveRoute = LogicArchiveRoute.of(str)).isLogicArchiveRoute()) {
                    if (logicArchiveRoute.isCurrentArchive()) {
                        archiveInfo2 = new ArchiveInfo(logicArchiveRoute.getRealArchiveKey() + logicArchiveRoute.getLogicSuffix(), null, null);
                    } else {
                        ArchiveInfo realArchiveInfo = (ArchiveInfo)existArchiveInfoList.get(logicArchiveRoute.getRealArchiveKey());
                        if (realArchiveInfo != null) {
                            archiveInfo2 = logicArchiveRoute.getLogic2ArchiveInfo(realArchiveInfo);
                        }
                    }
                }
                if (archiveInfo2 == null) continue;
                String planName = (String)DBArchiveRuntime.get().loadArchivePlanName(archiveInfo2.getKey());
                if (planName != null) {
                    archiveInfo2.setName(planName);
                    archiveInfo2.setDesc(planName);
                }
                routeInfo.getArchiveInfo().add(archiveInfo2);
            }
            if (log.isInfoEnabled()) {
                long ms = System.currentTimeMillis() - ts;
                StringBuilder msg = new StringBuilder("----MCArchive.get(String routeKey, String entityNumber)@").append(routeKey).append("@").append(entityNumber).append("----\r\n").append("->isLogEntity:").append(isLogEntity).append(",enableElastic:").append(enableElastic).append("----\r\n").append("->return").append("----\r\n");
                try {
                    msg.append(JSONUtils.toString((Object)routeInfo));
                }
                catch (IOException e) {
                    LOG.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
                msg.append("\r\n").append("#cost:").append(ms).append("ms\r\n");
                log.info(msg.toString());
            }
            return routeInfo;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @SdkInternal
    public static boolean isArchiveRoute(String routeKey) {
        routeKey = routeKey.trim().toLowerCase(Locale.ENGLISH);
        for (RouteInfo ri : MCArchive.get()) {
            for (ArchiveInfo item : ri.getArchiveInfo()) {
                if (!routeKey.equals(item.getKey()) || ri.getRouteKey().equals(item.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    @SdkInternal
    public static List<Map> __getAllDCInfo(String tenantId) {
        try {
            String data = MCArchive.getTenantDataValue(tenantId);
            ArrayList dcs = (ArrayList)JSONUtils.cast((String)data, ArrayList.class);
            return dcs;
        }
        catch (Exception e) {
            LOG.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            return null;
        }
    }

    @SdkInternal
    public static Map getDCInfo(String accountId, String tenantId) {
        try {
            String data = MCArchive.getTenantDataValue(tenantId);
            ArrayList dcs = (ArrayList)JSONUtils.cast((String)data, ArrayList.class);
            for (Object o : dcs) {
                String dcId;
                LinkedHashMap dc = (LinkedHashMap)o;
                if (Objects.isNull(dc.get("datacenterid")) || !accountId.equals(dcId = (String)dc.get("datacenterid"))) continue;
                return dc;
            }
        }
        catch (Exception e) {
            LOG.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return null;
    }

    private static String getTenantDataValue(String tenantId) {
        String tenantDataKey = String.format(ZK_TENANT_DATA_KEY, tenantId);
        if (tenantDataType.equalsIgnoreCase("zk")) {
            String zkUrl = System.getProperty("configUrl");
            String rootPath = ZKFactory.getZkRootPath((String)zkUrl);
            String tenantDataPath = rootPath + Instance.getClusterName() + ZK_SEP + ZK_COMMON_PROP_PATH + ZK_SEP + tenantDataKey;
            CuratorFramework zkClient = ZKFactory.getZKClient((String)zkUrl);
            try {
                byte[] values = (byte[])zkClient.getData().forPath(tenantDataPath);
                if (Objects.isNull(values)) {
                    throw new Exception("Value from zk is null, key:" + tenantDataKey);
                }
                return new String(values, StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                LOG.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        } else {
            String tenantDataValue = System.getProperty(tenantDataKey);
            if (tenantDataValue != null) {
                return tenantDataValue;
            }
        }
        return null;
    }

    @SdkInternal
    public static List<RouteInfo> get() {
        RequestContextInfo rc;
        long ts = System.currentTimeMillis();
        ArrayList<RouteInfo> rs = new ArrayList<RouteInfo>();
        try {
            rc = RequestContextInfo.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Map dc = MCArchive.getDCInfo(rc.getAccountId(), rc.getTenantId());
        if (dc == null) {
            return rs;
        }
        List<RouteInfo> routeInfoList = MCArchive.getFromJson(dc.get("archiveInfo"));
        if (log.isInfoEnabled()) {
            long ms = System.currentTimeMillis() - ts;
            StringBuilder msg = new StringBuilder("----MCArchive.get()@").append("->return").append("----\r\n");
            try {
                msg.append(JSONUtils.toString(routeInfoList));
            }
            catch (IOException e) {
                LOG.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            msg.append("\r\n").append("#cost:").append(ms).append("ms\r\n");
            log.info(msg.toString());
        }
        return routeInfoList;
    }

    @SdkInternal
    private static List<RouteInfo> getFromJson(Object archiveInfo) {
        if (Objects.isNull(archiveInfo)) {
            return Collections.emptyList();
        }
        HashMap<String, RouteInfo> routeInfoMap = new HashMap<String, RouteInfo>();
        ArrayList<String> mainKeys = new ArrayList<String>();
        ArrayList archiveKeys = (ArrayList)archiveInfo;
        for (Object o : archiveKeys) {
            LinkedHashMap archiveKey = (LinkedHashMap)o;
            String mainKey = (String)archiveKey.get("mainKey");
            RouteInfo routeInfo = (RouteInfo)routeInfoMap.get(mainKey);
            if (Objects.isNull(routeInfo)) {
                routeInfo = new RouteInfo(mainKey);
                routeInfo.getArchiveInfo().add(MCArchive.getCurrent(mainKey));
            }
            String key = (String)archiveKey.get("key");
            String name = (String)archiveKey.get("name");
            String desc = (String)archiveKey.get("desc");
            routeInfo.getArchiveInfo().add(new ArchiveInfo(key, name, desc));
            routeInfoMap.put(mainKey, routeInfo);
            if (mainKeys.contains(mainKey)) continue;
            mainKeys.add(mainKey);
        }
        ArrayList<RouteInfo> rs = new ArrayList<RouteInfo>(mainKeys.size());
        for (String mainKey : mainKeys) {
            rs.add((RouteInfo)routeInfoMap.get(mainKey));
        }
        return rs;
    }

    @SdkInternal
    private static ArchiveInfo getCurrent(String routeKey) {
        String currentLabel = Resources.get((String)"bos-dbengine", (String)"MCArchive_0", (String)"\u5f53\u671f", (Object[])new Object[0]);
        return new ArchiveInfo(routeKey, currentLabel, currentLabel);
    }

    @SdkInternal
    public static List<ArchiveInfo> getESArchiveInfo() {
        RequestContextInfo rc;
        long ts = System.currentTimeMillis();
        ArrayList<ArchiveInfo> rs = new ArrayList<ArchiveInfo>();
        try {
            rc = RequestContextInfo.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Map dc = MCArchive.getDCInfo(rc.getAccountId(), rc.getTenantId());
        if (dc == null) {
            return rs;
        }
        boolean enableElastic = false;
        try {
            enableElastic = Objects.isNull(dc.get("isEslogEnable")) ? false : (Boolean)dc.get("isEslogEnable");
        }
        catch (Exception ex) {
            log.error("MC config error: isEslogEnable not found.");
        }
        if (!enableElastic) {
            log.info("----MCArchive.getES()@->isEslogEnable:false");
            return rs;
        }
        List<ArchiveInfo> routeInfoList = new ArrayList<ArchiveInfo>();
        if (enableElastic) {
            routeInfoList = MCArchive.getESArchiveInfo(dc.get("esArchiveCluster"));
        }
        if (log.isInfoEnabled()) {
            long ms = System.currentTimeMillis() - ts;
            StringBuilder msg = new StringBuilder("----MCArchive.getES()@").append("->isEslogEnable:").append(enableElastic).append("----\r\n").append("->return").append("----\r\n");
            try {
                msg.append(JSONUtils.toString(routeInfoList));
            }
            catch (IOException e) {
                LOG.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            msg.append("\r\n").append("#cost:").append(ms).append("ms\r\n");
            log.info(msg.toString());
        }
        return routeInfoList;
    }

    @SdkInternal
    private static List<ArchiveInfo> getESArchiveInfo(Object esLogArchiveInfo) {
        if (Objects.isNull(esLogArchiveInfo)) {
            return Collections.emptyList();
        }
        ArrayList<ArchiveInfo> archiveInfo = new ArrayList<ArchiveInfo>();
        ArrayList archiveKeys = (ArrayList)esLogArchiveInfo;
        for (Object o : archiveKeys) {
            LinkedHashMap archiveKey = (LinkedHashMap)o;
            String key = ((String)archiveKey.get("key")).trim();
            String name = (String)archiveKey.get("name");
            String desc = (String)archiveKey.get("desc");
            archiveInfo.add(new ArchiveInfo(key, ArchiveRouteType.ES, name, desc));
        }
        return archiveInfo;
    }

    static {
        ConfigurationUtil.observeString((String)"archive.tenant.data.type", (String)tenantDataType, v -> {
            tenantDataType = v;
        });
    }
}

