/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.archive;

import kd.bos.util.ThreadLocals;

public final class WriteArchiveContext
implements AutoCloseable {
    private static final ThreadLocal<WriteArchiveContext> thWritable = ThreadLocals.create();
    private final WriteArchiveContext parent = thWritable.get();
    private final String routeKey;

    public static WriteArchiveContext create(String routeKey) {
        return new WriteArchiveContext(routeKey);
    }

    public static WriteArchiveContext get() {
        return thWritable.get();
    }

    private WriteArchiveContext(String routeKey) {
        this.routeKey = routeKey.trim().toLowerCase();
        thWritable.set(this);
    }

    public String getRouteKey() {
        return this.routeKey;
    }

    @Override
    public void close() {
        if (this.parent == null) {
            thWritable.remove();
        } else {
            thWritable.set(this.parent);
        }
    }
}

