/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.archive.config;

import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.db.archive.config.BaseArchiveConfig;
import kd.bos.db.archive.config.MainArchiveConfig;

public class ChildrenArchiveConfig
extends BaseArchiveConfig
implements ArchiveConfig {
    private String joinField;
    private String parentField;
    private String pkField;
    private ArchiveConfig parent;

    ChildrenArchiveConfig(String name, String table, String logicTable, String joinField, String parentField, ArchiveConfig parent, String primaryKey) {
        this.name = name;
        this.parent = parent;
        this.table = table.toLowerCase();
        this.logicTable = logicTable.toLowerCase();
        this.joinField = joinField.toLowerCase();
        this.parentField = parentField.toLowerCase();
        this.pkField = this.joinField;
        if (parent instanceof ChildrenArchiveConfig) {
            ((ChildrenArchiveConfig)parent).setPKField(this.joinField);
        }
        this.primaryKey = primaryKey;
        ArchiveConfig ac = parent;
        while (!(ac instanceof MainArchiveConfig)) {
            ac = ((ChildrenArchiveConfig)ac).getParent();
        }
        ((MainArchiveConfig)ac).addGroupTable(this.logicTable);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getLogicTable() {
        return this.logicTable;
    }

    public ArchiveConfig getParent() {
        return this.parent;
    }

    public String getJoinField() {
        return this.joinField;
    }

    public String getParentField() {
        return this.parentField;
    }

    public String toString() {
        return this.table + "." + this.joinField + "=" + this.parent.getTable() + "." + this.parentField;
    }

    public String getPKField() {
        return this.pkField;
    }

    public void setPKField(String pkField) {
        this.pkField = pkField;
    }

    public boolean isLangTableConfig() {
        Boolean b = (Boolean)this.getAttribute("is_lang_table");
        return b != null && b != false;
    }

    public void setLangTableConfig() {
        this.setAttribute("is_lang_table", Boolean.TRUE);
    }

    public boolean isGroupTableConfig() {
        Boolean b = (Boolean)this.getAttribute("is_group_table");
        return b != null && b != false;
    }

    public void setGroupTableConfig() {
        this.setAttribute("is_group_table", Boolean.TRUE);
    }

    public boolean isTcTableConfig() {
        Boolean b = (Boolean)this.getAttribute("is_tc_table");
        return b != null && b != false;
    }

    public void setTcTableConfig() {
        this.setAttribute("is_tc_table", Boolean.TRUE);
    }

    public boolean isWbTableConfig() {
        Boolean b = (Boolean)this.getAttribute("is_wb_table");
        return b != null && b != false;
    }

    public void setWbTableConfig() {
        this.setAttribute("is_wb_table", Boolean.TRUE);
    }

    public boolean isLkTableConfig() {
        Boolean b = (Boolean)this.getAttribute("is_lk_table");
        return b != null && b != false;
    }

    public void setLkTableConfig() {
        this.setAttribute("is_lk_table", Boolean.TRUE);
    }

    public boolean isEntryTableConfig() {
        return !this.isLangTableConfig() && !this.isGroupTableConfig();
    }
}

