/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.archive.config;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kd.bos.db.archive.config.ArchiveConfig;
import kd.bos.db.archive.config.BaseArchiveConfig;

public class MainArchiveConfig
extends BaseArchiveConfig
implements ArchiveConfig {
    private String archiveRoute;
    private int suffix;
    private Set<String> groupTables = new HashSet<String>();

    MainArchiveConfig(String name, String table, String logicTable, String archiveRoute, int suffix, String primaryKey) {
        this.name = name;
        this.table = table.toLowerCase();
        this.logicTable = logicTable.toLowerCase();
        this.archiveRoute = archiveRoute;
        this.suffix = suffix;
        this.primaryKey = primaryKey;
        this.groupTables.add(this.logicTable);
    }

    public boolean isTablePluginConfig() {
        Boolean b = (Boolean)this.getAttribute("is_table_plugin");
        return b != null && b != false;
    }

    public void setTablePluginConfig() {
        this.setAttribute("is_table_plugin", Boolean.TRUE);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getLogicTable() {
        return this.logicTable;
    }

    public Set<String> getGroupTables() {
        return Collections.unmodifiableSet(this.groupTables);
    }

    void addGroupTable(String table) {
        this.groupTables.add(table);
    }

    public String getArchiveRoute() {
        return this.archiveRoute;
    }

    public void setArchiveRoute(String archiveRoute) {
        this.archiveRoute = archiveRoute;
    }

    public int getSuffix() {
        return this.suffix;
    }

    public void setSuffix(int suffix) {
        this.suffix = suffix;
    }
}

