/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.archive.configchanged;

import kd.bos.db.archive.configchanged.DBArchiveConfigInfo;
import kd.bos.db.archive.configchanged.DBArchiveConfigListener;
import kd.bos.db.sharding.ZKWatchValueNotifier;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.xdb.exception.ExceptionUtil;

public class DBArchiveConfigNotifier
extends ZKWatchValueNotifier {
    private static final String ARCHIVE_ENTITY_CONFIG_WATCHER = "archive.entity.config.watcher";
    private static final String FIRE_RELOAD_ARCHIVE_ENTITY_CONFIG_LOCK_KEY = "/archive/fire_reload_entity_config";

    public static void registerReloadArchiveConfigListener(final DBArchiveConfigListener l) {
        ConfigurationChangeListener listener = new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                try {
                    DBArchiveConfigInfo ai = DBArchiveConfigListener.fromKey((String)newValue);
                    l.onReceiveReloadArchiveConfig(ai);
                }
                catch (Throwable e) {
                    throw ExceptionUtil.wrap((Throwable)e);
                }
            }
        };
        DBArchiveConfigNotifier.observeChange(ARCHIVE_ENTITY_CONFIG_WATCHER, listener);
    }

    public static void fireReloadArchiveConfig(String entityName) {
        String value = DBArchiveConfigListener.currentKey(entityName);
        log.info("fireReloadArchiveConfig " + entityName + " " + value);
        DBArchiveConfigNotifier.fireLimit(FIRE_RELOAD_ARCHIVE_ENTITY_CONFIG_LOCK_KEY, ARCHIVE_ENTITY_CONFIG_WATCHER, value);
    }
}

