/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.bundle.Resources;
import kd.bos.config.client.ConfigurationFactory;
import kd.bos.db.DBType;
import kd.bos.db.adaptation.DatabaseAdaptationFactorys;
import kd.bos.db.datasource.DataSourceInfo;
import kd.bos.db.datasource.DataSourceURLs;
import kd.bos.db.datasource.InitCustomDataSource;
import kd.bos.db.splittingread.SplittingReadConfig;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.ksql.CONSTANT;
import kd.bos.security.KDCallerInfo;
import kd.bos.security.KDReflection;
import kd.bos.security.PermissionManager;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public final class DBConfig {
    public static final String oracle_5236_as_dm = "oracle_5236_as_dm";
    public static final String pg_as_gs = "pg_as_gs";
    public static final String pg_as_gs100 = "pg_as_gs100";
    private static final String MCDBDriverKey = "mcdbdriver_ksql";
    private static final String MCDBUrlKey = "mcdburl_ksql";
    private static final List<DBConfig> replaceDBConfigList = new ArrayList<DBConfig>();
    private static final AtomicInteger idSeq = new AtomicInteger();
    private String schema;
    private String mode;
    private String ip;
    private int port;
    private final int id;
    private String driver;
    private String url;
    private String user;
    private String password;
    private DBType dbType;
    private int poolInitialSize = 2;
    private int poolMaxIdle = 1;
    private int poolMinIdle = 1;
    private int poolMaxActive = 100;
    private int poolMaxWait = 60000;
    private String tenantId;
    private String routeKey;
    private String accountId;
    private boolean readOnly;
    private int loadFactor = 0;
    private boolean isCluster;
    private String clusterDbUrl;
    private Properties defaultProperties = new Properties();
    private String sharingId = null;
    private String dbShardedIdentity = null;
    private static Map<String, Account> accountCacheMap = new ConcurrentHashMap<String, Account>();

    public DBConfig() {
        KDCallerInfo caller;
        PermissionManager.check();
        if (KDReflection.isEnableSecurity() && KDReflection.isCustomerClass((Class)(caller = KDReflection.getCallerClassUntilNot((Class[])new Class[]{DBConfig.class})).getCallerClass())) {
            String msg = Resources.get((String)"bos-dbengine", (String)"DBConfig_0", (String)"\u7981\u6b62\u521b\u5efaDBConfig: ", (Object[])new Object[0]) + caller.getCallerClass().getName() + '#' + KDReflection.getCallerMethodName((int)caller.getCallStackDepth());
            throw KDReflection.securityException((String)msg);
        }
        this.id = idSeq.incrementAndGet();
    }

    public String getSchema() {
        return this.schema;
    }

    public String getMode() {
        return this.mode;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public int getPoolMaxActive() {
        return this.poolMaxActive;
    }

    public int getPoolInitialSize() {
        return this.poolInitialSize;
    }

    public int getPoolMaxWait() {
        return this.poolMaxWait;
    }

    public int getPoolMaxIdle() {
        return this.poolMaxIdle;
    }

    public int getPoolMinIdle() {
        return this.poolMinIdle;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    void setRouteKey(String routeKey) {
        this.routeKey = routeKey == null ? null : routeKey.trim().toLowerCase();
    }

    public String getRouteKey() {
        return this.routeKey;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getLoadFactor() {
        return this.loadFactor;
    }

    public String getUser() {
        PermissionManager.check();
        return this.user;
    }

    void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        PermissionManager.check();
        return this.password;
    }

    public String getClusterDbUrl() {
        return this.clusterDbUrl;
    }

    public boolean isCluster() {
        return this.isCluster;
    }

    public Properties getDefaultProperties() {
        return this.defaultProperties;
    }

    public int getId() {
        return this.id;
    }

    public final String getSharingId() {
        if (this.sharingId == null) {
            int p = this.url.indexOf(63);
            String urlId = p == -1 ? this.url : this.url.substring(0, p);
            this.sharingId = (this.tenantId + '#' + urlId + '#' + this.accountId).toLowerCase();
            if (this.dbType == DBType.Oracle || this.dbType == DBType.DM || this.dbType == DBType.GS100) {
                this.sharingId = this.sharingId + '#' + this.user.toLowerCase();
            } else if (this.schema != null && (this.dbType == DBType.PostgreSQL || this.dbType == DBType.GS || this.dbType == DBType.GaussDB || this.dbType == DBType.Gauss200 || this.dbType == DBType.Greenplum)) {
                this.sharingId = this.sharingId + '#' + this.schema.toLowerCase();
                if (CONSTANT.CONNECTION_SHARD && this.dbType == DBType.PostgreSQL && this.mode != null) {
                    this.sharingId = this.sharingId + '#' + this.mode.toLowerCase();
                }
                if (this.isCluster && this.readOnly) {
                    this.sharingId = this.sharingId + "#readonly";
                }
            } else if (this.dbType == DBType.HANA) {
                this.sharingId = this.sharingId + '#' + this.schema + '#' + this.mode + '#' + this.user;
            } else if (this.dbType == DBType.ClickHouse) {
                this.sharingId = this.sharingId + '#' + this.schema + '#' + this.mode + '#' + this.user;
            }
        }
        return this.sharingId;
    }

    private String getDBShardedIdentity() {
        if (this.dbShardedIdentity == null) {
            int p = this.dbType == DBType.MySQL ? this.url.indexOf(this.schema) : this.url.indexOf(63);
            this.dbShardedIdentity = p == -1 ? this.url.toLowerCase() : this.url.substring(0, p).toLowerCase();
            this.dbShardedIdentity = this.dbShardedIdentity + '#' + this.user.toLowerCase();
        }
        return this.dbShardedIdentity;
    }

    public final boolean canSharingDB(DBConfig dbConfig) {
        return this.getDBShardedIdentity().equals(dbConfig.getDBShardedIdentity());
    }

    public boolean canSharing(DBConfig conf) {
        return this.getSharingId().equals(conf.getSharingId());
    }

    public DBType getDBType() {
        return this.dbType;
    }

    public String toString() {
        return this.id + 35 + this.url;
    }

    private boolean isTemplate() {
        return this.accountId == null && this.tenantId == null;
    }

    private DBConfig copyAs(String tenantId, String accountId) {
        DBConfig ret = new DBConfig();
        ret.schema = this.schema;
        ret.mode = this.mode;
        ret.ip = this.ip;
        ret.port = this.port;
        ret.driver = this.driver;
        ret.url = this.url;
        ret.user = this.user;
        ret.password = this.password;
        ret.dbType = this.dbType;
        ret.poolInitialSize = this.poolInitialSize;
        ret.poolMaxIdle = this.poolMaxIdle;
        ret.poolMinIdle = this.poolMinIdle;
        ret.poolMaxActive = this.poolMaxActive;
        ret.poolMaxWait = this.poolMaxWait;
        ret.tenantId = tenantId;
        ret.routeKey = this.routeKey;
        ret.accountId = accountId;
        ret.readOnly = this.readOnly;
        ret.loadFactor = this.loadFactor;
        ret.isCluster = this.isCluster;
        ret.clusterDbUrl = this.clusterDbUrl;
        ret.defaultProperties = this.defaultProperties;
        ret.sharingId = this.sharingId;
        return ret;
    }

    public static List<DBConfig> loadFromDataCenter(String tenantId, String routeKey, String accountId, boolean useCache) {
        PermissionManager.check();
        if (tenantId == null || tenantId.trim().length() == 0) {
            throw new IllegalArgumentException(Resources.get((String)"bos-dbengine", (String)"DBConfig_1", (String)"\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a\u3002", (Object[])new Object[0]));
        }
        if (accountId == null || accountId.trim().length() == 0) {
            throw new IllegalArgumentException(Resources.get((String)"bos-dbengine", (String)"DBConfig_2", (String)"accountId\u4e0d\u80fd\u4e3a\u7a7a\u3002", (Object[])new Object[0]));
        }
        try (TraceSpan ts = Tracer.create((String)"datasource", (String)"loadFromDataCenter");){
            ts.addTag("tenantId", tenantId);
            ts.addTag("routeKey", routeKey);
            ts.addTag("accountId", accountId);
            List<DBConfig> list = DBConfig.findInDataCenter(tenantId, routeKey, accountId, useCache);
            return list;
        }
    }

    private static Account loadAccount(String tenantId, String accountId) {
        try (TraceSpan ts = Tracer.create((String)"datasource", (String)"loadAccount");){
            Account ac = AccountUtils.getCorrectAccount(accountId, tenantId);
            if (!accountId.equals(ac.getAccountId())) {
                String msg = Resources.get((String)"bos-dbengine", (String)"DBConfig_3", (String)"AccountID\u4e0d\u5339\u914d\uff1a\u67e5\u8be2=%1$s\uff0c\u8fd4\u56de=%2$s", (Object[])new Object[]{accountId, ac.getAccountId()});
                throw new RuntimeException(msg);
            }
            SplittingReadConfig.turnAccount(ac);
            Account account = ac;
            return account;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<DBConfig> findInDataCenter(String tenantId, String routeKey, String accountId, boolean useCache) {
        String curRouteKey;
        Account ac;
        String accountCacheKey = (tenantId + '#' + accountId).toLowerCase();
        if (useCache) {
            ac = accountCacheMap.get(accountCacheKey);
            if (ac == null) {
                Map<String, Account> map = accountCacheMap;
                synchronized (map) {
                    ac = accountCacheMap.get(accountCacheKey);
                    if (ac == null) {
                        ac = DBConfig.loadAccount(tenantId, accountId);
                        accountCacheMap.put(accountCacheKey, ac);
                    }
                }
            }
        } else {
            ac = DBConfig.loadAccount(tenantId, accountId);
            accountCacheMap.put(accountCacheKey, ac);
        }
        ArrayList<DBConfig> ret = new ArrayList<DBConfig>(8);
        String lrouteKey = routeKey.toLowerCase(Locale.ENGLISH);
        if (!replaceDBConfigList.isEmpty()) {
            for (DBConfig config : replaceDBConfigList) {
                String string = curRouteKey = config.getRouteKey() == null ? "" : config.getRouteKey().trim();
                if (!"*".equals(curRouteKey) && !lrouteKey.equals(curRouteKey)) continue;
                if (config.isTemplate()) {
                    config = config.copyAs(tenantId, accountId);
                } else if (!tenantId.equals(config.getTenantId()) || !accountId.equals(config.getAccountId())) continue;
                ret.add(config);
            }
            if (!ret.isEmpty()) {
                return ret;
            }
        }
        for (DBInstance db : ac.getDBInstanceList()) {
            String string = curRouteKey = db.getRouteKey() == null ? "" : db.getRouteKey().trim();
            if (!lrouteKey.equals(curRouteKey.toLowerCase(Locale.ENGLISH))) continue;
            DBConfig dbc = DBConfig.fromDBInstance(db, tenantId, accountId);
            ret.add(dbc);
        }
        return ret;
    }

    static DBConfig fromDBInstance(DBInstance db, String tenantId, String accountId) {
        DBConfig dbc = new DBConfig();
        dbc.readOnly = db.isReadOnly();
        dbc.setRouteKey((db.getRouteKey() == null ? "" : db.getRouteKey().trim()).toLowerCase());
        dbc.accountId = accountId;
        dbc.tenantId = tenantId;
        dbc.loadFactor = db.getLoadFactor();
        dbc.user = db.getDbuser();
        dbc.password = db.getDbpassword();
        dbc.schema = db.getDBInsatnce();
        dbc.ip = db.getDbip();
        dbc.port = Integer.parseInt(db.getDbport());
        dbc.driver = "kd.bos.ksql.shell.Driver";
        dbc.isCluster = db.isCluster();
        dbc.clusterDbUrl = db.getClusterDbUrl();
        switch (db.getDbtype()) {
            case "0": {
                if (dbc.port == 5236 && Boolean.getBoolean(oracle_5236_as_dm)) {
                    dbc.dbType = DBType.DM;
                    break;
                }
                dbc.dbType = DBType.Oracle;
                break;
            }
            case "2": {
                dbc.dbType = DBType.MySQL;
                break;
            }
            case "1": {
                if (Boolean.getBoolean(pg_as_gs)) {
                    dbc.dbType = DBType.GS;
                    break;
                }
                if (Boolean.getBoolean(pg_as_gs100)) {
                    dbc.dbType = DBType.GS100;
                    break;
                }
                dbc.dbType = DBType.PostgreSQL;
                dbc.mode = db.getDbSchema();
                break;
            }
            case "3": {
                dbc.dbType = DBType.DM;
                break;
            }
            case "4": {
                if (Boolean.getBoolean(pg_as_gs100)) {
                    dbc.dbType = DBType.GS100;
                } else if (Boolean.getBoolean(pg_as_gs)) {
                    dbc.dbType = DBType.GS;
                } else {
                    dbc.dbType = DBType.PostgreSQL;
                    dbc.mode = db.getDbSchema();
                }
                if (!Boolean.getBoolean(pg_as_gs100)) break;
                dbc.dbType = DBType.GS100;
                break;
            }
            case "5": {
                dbc.dbType = DBType.GS100;
                if (!Boolean.getBoolean(pg_as_gs)) break;
                dbc.dbType = DBType.GS;
                break;
            }
            case "6": {
                dbc.dbType = DBType.SQLServer;
                break;
            }
            case "14": {
                dbc.dbType = DBType.GaussDB;
                break;
            }
            case "15": {
                dbc.dbType = DBType.KingBase;
                break;
            }
            case "16": {
                dbc.dbType = DBType.Vastbase;
                break;
            }
            case "17": {
                dbc.dbType = DBType.TDSQL;
                break;
            }
            case "18": {
                dbc.dbType = DBType.Gbase;
                break;
            }
            case "19": {
                dbc.dbType = DBType.TiDB;
                break;
            }
            case "20": {
                dbc.dbType = DBType.YasDB;
                break;
            }
            case "21": {
                dbc.dbType = DBType.OceanBase_Oracle;
                break;
            }
            case "101": {
                dbc.dbType = DBType.HANA;
                dbc.mode = db.getDbSchema();
                break;
            }
            case "103": {
                dbc.dbType = DBType.Gauss200;
                break;
            }
            case "104": {
                dbc.dbType = DBType.Greenplum;
                dbc.mode = db.getDbSchema();
                break;
            }
            case "105": {
                dbc.dbType = DBType.ClickHouse;
                dbc.mode = db.getDbSchema();
                break;
            }
            default: {
                String msg = Resources.get((String)"bos-dbengine", (String)"DBConfig_5", (String)"\u6570\u636e\u4e2d\u5fc3\u5b9e\u4f8b\u7684\u6570\u636e\u5e93\u7c7b\u578b\u4e0d\u6b63\u786e\uff1a", (Object[])new Object[0]) + db.getDbtype() + ", tenantId=" + tenantId + ", accountId=" + accountId + ", routeKey=" + db.getRouteKey();
                throw new RuntimeException(msg);
            }
        }
        dbc.url = dbc.isCluster ? (CONSTANT.CONNECTION_SHARD && dbc.dbType == DBType.PostgreSQL ? DataSourceURLs.genClusterUrl(dbc.dbType, dbc.clusterDbUrl, dbc.schema, dbc.mode) : DataSourceURLs.genClusterUrl(dbc.dbType, dbc.clusterDbUrl, dbc.schema)) : (CONSTANT.CONNECTION_SHARD && dbc.dbType == DBType.PostgreSQL ? DataSourceURLs.genURL(dbc.dbType, dbc.ip, dbc.port, dbc.schema, dbc.mode) : (dbc.dbType == DBType.HANA || dbc.dbType == DBType.Greenplum ? DataSourceURLs.genURL(dbc.dbType, dbc.ip, dbc.port, dbc.schema, dbc.mode) : DataSourceURLs.genURL(dbc.dbType, dbc.ip, dbc.port, dbc.schema)));
        dbc.defaultProperties.putAll((Map<?, ?>)db.getDefaultProperties());
        if (dbc.getDBType() == DBType.PostgreSQL || dbc.getDBType() == DBType.GaussDB) {
            dbc.url = DatabaseAdaptationFactorys.getFactory().getDataSourceURLCreator(dbc.getDBType()).createConnectionURL(db);
        }
        return dbc;
    }

    private static DBConfig getMCDBInfo() {
        PermissionManager.check();
        DBConfig dbInfo = new DBConfig();
        dbInfo.driver = ConfigurationFactory.getGlobalConfiguration().getProperty(MCDBDriverKey);
        String url = ConfigurationFactory.getGlobalConfiguration().getProperty(MCDBUrlKey);
        dbInfo.url = Encrypters.decode((String)url);
        return dbInfo;
    }

    public static Connection getMCConnection() throws Exception {
        PermissionManager.check();
        DBConfig mcDBInfo = DBConfig.getMCDBInfo();
        Class.forName(mcDBInfo.driver);
        return DriverManager.getConnection(mcDBInfo.url);
    }

    static DBConfig of(String tenantId, String accountId, String routeKey, DBType dbType, String ip, int port, String db, String schema, String user, String pwd, Properties dataSourceProperties, int loadFactor, boolean readOnly) {
        return DBConfig.of(tenantId, accountId, routeKey, dbType, ip, port, db, schema, user, pwd, dataSourceProperties, loadFactor, readOnly, false, null);
    }

    static DBConfig of(String tenantId, String accountId, String routeKey, DBType dbType, String ip, int port, String db, String user, String pwd, Properties dataSourceProperties, int loadFactor, boolean readOnly) {
        return DBConfig.of(tenantId, accountId, routeKey, dbType, ip, port, db, null, user, pwd, dataSourceProperties, loadFactor, readOnly, false, null);
    }

    static DBConfig of(String tenantId, String accountId, String routeKey, DBType dbType, String ip, int port, String db, String schema, String user, String pwd, Properties dataSourceProperties, int loadFactor, boolean readOnly, boolean isCluster, String clusterDbUrl) {
        DBConfig dbc = new DBConfig();
        dbc.readOnly = false;
        dbc.setRouteKey(routeKey);
        dbc.accountId = accountId;
        dbc.tenantId = tenantId;
        dbc.loadFactor = 1;
        dbc.user = user;
        dbc.password = pwd;
        dbc.schema = db;
        dbc.mode = schema;
        dbc.ip = ip;
        dbc.port = port;
        dbc.driver = "kd.bos.ksql.shell.Driver";
        dbc.dbType = dbType;
        dbc.url = isCluster ? DataSourceURLs.genClusterUrl(dbc.dbType, clusterDbUrl, dbc.schema) : DataSourceURLs.genURL(dbc.dbType, dbc.ip, dbc.port, dbc.schema);
        if (dataSourceProperties != null) {
            dbc.defaultProperties.putAll((Map<?, ?>)dataSourceProperties);
        }
        dbc.loadFactor = loadFactor;
        dbc.readOnly = readOnly;
        return dbc;
    }

    static void __replaceDataCenter(List<DBConfig> list) {
        KDCallerInfo caller;
        if (KDReflection.isEnableSecurity() && KDReflection.isCustomerClass((Class)(caller = KDReflection.getCallerClassUntilNot((Class[])new Class[]{DataSourceInfo.class, InitCustomDataSource.class})).getCallerClass())) {
            String msg = Resources.get((String)"bos-dbengine", (String)"DBConfig_6", (String)"\u7981\u6b62\u81ea\u5b9a\u4e49\u6570\u636e\u6e90: ", (Object[])new Object[0]) + caller.getCallerClass().getName() + '#' + KDReflection.getCallerMethodName((int)caller.getCallStackDepth());
            throw KDReflection.securityException((String)msg);
        }
        replaceDBConfigList.addAll(list);
    }
}

