/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.db.datasource;

import kd.bos.util.ConfigurationUtil;

public class DataSourceConfig {
    private static final boolean enableReplicationCheck = Boolean.parseBoolean(System.getProperty("db.datasource.enableReplicationCheck", "true"));
    private static int replicationDelayInfoUpdateTaskExecuteDelayMinute = 1;
    private static int replicationDelayInfoCacheExpireMinute = 5;
    private static int replicationDelayInfoQueryTimeoutSeconds = 3;
    private static int mysqlMaxReplicationDelaySeconds = 600;
    private static int pgMaxReplicationDelayBytes = 0x10000000;
    private static int mysqlDelayInfoQueryTimes = 3;

    public static int getReplicationDelayInfoUpdateTaskExecuteDelayMinute() {
        return replicationDelayInfoUpdateTaskExecuteDelayMinute;
    }

    public static int getReplicationDelayInfoQueryTimeoutSeconds() {
        return replicationDelayInfoQueryTimeoutSeconds;
    }

    public static int getMysqlMaxReplicationDelaySeconds() {
        return mysqlMaxReplicationDelaySeconds;
    }

    public static int getPgMaxReplicationDelayBytes() {
        return pgMaxReplicationDelayBytes;
    }

    public static int getMysqlDelayInfoQueryTimes() {
        return mysqlDelayInfoQueryTimes;
    }

    public static int getReplicationDelayInfoCacheExpireMinute() {
        return replicationDelayInfoCacheExpireMinute;
    }

    public static boolean isEnableReplicationCheck() {
        return enableReplicationCheck;
    }

    static {
        ConfigurationUtil.observeInteger((String)"db.datasource.replicationDelayInfoUpdateTaskExecuteDelayMinute", (int)1, v -> {
            v = Math.max(1, v);
            replicationDelayInfoUpdateTaskExecuteDelayMinute = v;
        });
        ConfigurationUtil.observeInteger((String)"db.datasource.replicationDelayInfoCacheExpireMinute", (int)5, v -> {
            if (v <= 0) {
                v = 5;
            }
            replicationDelayInfoCacheExpireMinute = v;
        });
        ConfigurationUtil.observeInteger((String)"db.datasource.replicationDelayInfoQueryTimeoutSeconds", (int)3, v -> {
            v = Math.abs(v);
            v = Math.min(60, v);
            replicationDelayInfoQueryTimeoutSeconds = v;
        });
        ConfigurationUtil.observeInteger((String)"db.datasource.mysql.maxReplicationDelaySeconds", (int)600, v -> {
            if (v <= 0) {
                v = 600;
            }
            mysqlMaxReplicationDelaySeconds = v;
        });
        ConfigurationUtil.observeInteger((String)"db.datasource.pg.maxReplicationDelayBytes", (int)0x10000000, v -> {
            if (v <= 0) {
                v = 0x10000000;
            }
            if (v <= 16384) {
                v = 16384;
            }
            pgMaxReplicationDelayBytes = v;
        });
        ConfigurationUtil.observeInteger((String)"db.datasource.mysql.delayInfoQueryTimes", (int)3, v -> {
            v = Math.max(3, v);
            v = Math.min(15, v);
            mysqlDelayInfoQueryTimes = v;
        });
    }
}

